--******************************************************************************
--*  UndoSelection 1.0               for Max 4.2                               *
--*  by Ofer Zelichover (c) 01/2002                                            *
--*  www.tdp.nu/ofer   ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--*  based on idea by Jim Jagger                                               *
--******************************************************************************
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a credit if you do so ;))                *
--******************************************************************************
--*  This script comes with no waranty!                                        *
--*  Although I tried this script and couldn't find any problems with it, I can*
--*  in no way be held responsible for any kind of loss or damage, whether     *
--*  direct or indirect, due to the use of this script.                        *
--*                                                                            *
--*  ********************************************************************      *
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***      *
--*  ********************************************************************      *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** versions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in this script, please let me know.                  *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--* Adds an undo/redo feature only for selection (doesn't affect max's undo).  *
--*                                                                            *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* created : 05/01/2002                                                       *
--*                                                                            *
--* Known issues:                                                              *
--*                                                                            *
--*Need to add:                                                                *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*        undoSelection.ms         - in the <max_root>\scripts\startup folder *
--*                                                                            *
--*   Restart max. You will find it in the customize user interface under      *
--*   "Os Tools" category. You can now assign the undo/redo Selection scripts  *
--*   to buttons, menus, keyboard shortcuts or quads.                          *
--******************************************************************************


-- how many levels of undo
global undoSelectionLevels = 32

-- do NOT chnge below here
global undoSelectionList = #()
global redoSelectionList = #()
global prevSelection = undefined
global registerUndoSelCallback

-- when a new selection is made, add it to the undo list.
fn registerUndoSelCallback = (
	try (
		if undoSelectionList.count >= undoSelectionLevels then
			deleteItem undoSelectionList 1
		if prevSelection != undefined then
			append undoSelectionList (prevSelection)
		prevSelection = getCurrentSelection()
		redoSelectionList = #()
	)catch()
)

-- undoSelection macroScript
------------------------------
macroScript undoSelection
	category: "Os Tools"
	buttonText: "UndoSel"
	tooltip: "Undo Selection"
(
	on execute do (
		undo off (
			try(callbacks.removeScripts id:#undoSelection)catch()
			try(select undoSelectionList[undoSelectionList.count])catch()
			if undoSelectionlist.count > 0 then
				try(append redoSelectionList prevSelection)catch()
			prevSelection = getCurrentSelection()
			try(deleteItem undoSelectionList undoSelectionList.count)catch()
			callbacks.addScript #selectionSetChanged "registerUndoSelCallback()" id:#undoSelection
		)
	)

--	on isEnabled do undoSelectionList.count > 0
)-- end undoSelection macroScript
	
-- redoSelection macroScript
------------------------------
macroScript redoSelection 
	category: "Os Tools"
	buttonText: "RedoSel"
	tooltip: "Redo Selection"
(
	on execute do (
		undo off (
			try(callbacks.removeScripts id:#undoSelection)catch()
			try(select redoSelectionList[redoSelectionList.count])catch()
			if redoSelectionlist.count > 0 then
				try(append undoSelectionList prevSelection)catch()
			prevSelection = getCurrentSelection()
			try(deleteItem redoSelectionList redoSelectionList.count)catch()
			callbacks.addScript #selectionSetChanged "registerUndoSelCallback()" id:#undoSelection
		)
	)

--	on isEnabled do redoSelectionList.count > 0
)--end redoSelection macroScript

-- try to delete old callbacks
try(callbacks.removeScripts id:#undoSelection)catch()
--register a selectionSetChanged callback
callbacks.addScript #selectionSetChanged "registerUndoSelCallback()" id:#undoSelection
