--******************************************************************************
--*                                                                            *
--*  safeSave tools v1.1              for Max 4.2                              *
--*  by Ofer Zelichover (c) 12/2001                                            *
--*  www.tdp.nu/ofer   ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--******************************************************************************
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a credit if you do so ;))                *
--******************************************************************************
--*  This script comes with no waranty!                                        *
--*  Although I tried this script and couldn't find any problems with it, I can*
--*  in no way be held responsible for any kind of loss or damage, whether     *
--*  direct or indirect, due to the use of this script.                        *
--*                                                                            *
--*  ********************************************************************      *
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***      *
--*  ********************************************************************      *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** versions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in this script, please let me know.                  *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--* Due to a bug in max 4.x it is possible to overwrite files that are marked  *
--* as read-only. safeSave tools are a set of tool to replace the max internal *
--* save functions, and solve this problem (until Discreet with fix it in      *
--* future versions of max).                                                   *
--* safeSave tools consists of four save tools:                                *
--* +safeSave - replaces the max save (file > save)                            *
--* +safeSaveAs - replaces the max save as (file > save as)                    *
--* +safeSaveSelected - replaces the max save selected (file > save selected)  *
--* +safeSaveIncremental - replaces the max save incremental (the + in save as)*
--* +safeSave Major Inc - a new function to save incremental major versions.   *
--* +safeSave Minor Inc - a new function to save incremental minor versions.   *
--*                                                                            *
--* The tools are macroscripts so you can put assign them to button, keys or   *
--* quad options.                                                              *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* Created: 11/12/2001 - Ver 1.0                                              *
--*    21/01/2002 - Ver 1.1                                                    *
--*     - Added two new functions, Major and Minor incremental save.           *
--*       Idea by Dave Stewart.                                                *
--*                                                                            *
--* Known issues:                                                              *
--*                                                                            *
--* Need to add:                                                               *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*         safeSave-v1_1.ms      - anywhere                                   *
--*                                                                            *
--*  After you run the script, the safeSave tools will appear in the           *
--*  "safeSave" category in the customize ui menu.                             *
--*                                                                            *
--******************************************************************************


--***************************************************************
-- Start of macroScripts
--***************************************************************

------------------------------------------------------------------------------
-- safeSafe macroscript
------------------------------------------------------------------------------
macroScript safeSave
	category: "safeSave"
	tooltip: "safeSave"
	buttonText: "safeSave"
(
	on execute do (
		if NOT (getFileAttribute (maxFilePath+maxFileName) #readOnly) then
			saveMaxFile (maxFilePath+maxFileName)
		else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
	)
)

------------------------------------------------------------------------------
-- safeSafe as macroscript
------------------------------------------------------------------------------
macroScript safeSaveAs
	category: "safeSave"
	tooltip: "safeSave As"
	buttonText: "safeSaveAs"
(
	on execute do (
		local fName = getSaveFileName caption:"safeSave File As" filename:(maxFilePath+maxFileName) types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if NOT (getFileAttribute fName #readOnly) then
			saveMaxFile fName
		else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
	)
)

------------------------------------------------------------------------------
-- safeSafe selected macroscript
------------------------------------------------------------------------------
macroScript safeSaveSelected 
	category: "safeSave"
	tooltip: "safeSave Selected"
	buttonText: "safeSave Selected"
(
	on isEnabled return (selection.count>0)
	
	on execute do (
		if selection.count == 0 then return()
		local fName = getSaveFileName caption:"safeSave File As" types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if NOT (getFileAttribute fName #readOnly) then
			saveNodes selection fName
		else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"	
	)
)

------------------------------------------------------------------------------
-- safeSafe incremental macroscript
------------------------------------------------------------------------------
macroScript safeSaveIncremental
	category: "safeSave"
	tooltip: "safeSave Incremental (+)"
	buttonText: "safeSave Inc(+)"
(
	fn getIncFileName f = (
		try (
			local fName = getFilenameFile f
			local fExt = getFilenameType f
			local fPath = getFilenamePath f
			local digits = "0123456789"
			local numStr = "01"
			if findString digits fName[fName.count] != undefined then (
				local str = ""
				while (findString digits fName[fName.count] != undefined) do (
					str = fName[fName.count]+str
					fName = subString fName 1 (fName.count-1)
				)
				numStr = ((str as integer)+1) as string
			)
			if numStr.count < 2 then numStr = "0" + numStr
			(fPath + fName + numStr + fExt)
		) catch(undefined)
	)

	on execute do (
		local fName = getIncFileName (maxFilePath+maxFileName)
		if fName == undefined OR (getFiles fName).count != 0 then
			fName = getSaveFileName caption:"safeSave File As" filename:(maxFilePath+maxFileName) types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if (getFiles fName).count == 0 then (
			saveMaxFile fName
		) else (
			if NOT (getFileAttribute fName #readOnly) then
				saveMaxFile fName
			else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
		)
	)
)

------------------------------------------------------------------------------
-- safeSafe major incremental macroscript
------------------------------------------------------------------------------
macroScript safeSaveIncMajor
	category: "safeSave"
	tooltip: "safeSave Major Incremental (+)"
	buttonText: "safeSave(+)"
(
	fn toLowerCase str = (
		local lowerCase = "abcdefghijklmnopqrstuvwxyz"
		local upperCase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
		local outStr = ""
		for i = 1 to str.count do (
			local n = findString upperCase str[i]
			if n != undefined then outStr += lowerCase[n]
			else outStr += str[i]
		)
		outStr
	)
	
	fn getMajorIncFileName f = (
		try (
			local fName = getFilenameFile f
			local fExt = getFilenameType f
			local fPath = getFilenamePath f
			local digits = "0123456789"
			local letters = "abcdefghijklmnopqrstuvwxyz"
			local numStr = "01"
			try (
				if findString letters (toLowerCase fName[fName.count]) != undefined AND
				   findString digits fName[fName.count-1] != undefined then (
					fName = subString fName 1 (fName.count-1)
				)
			)catch()
			if findString digits fName[fName.count] != undefined then (
				local str = ""
				while (findString digits fName[fName.count] != undefined) do (
					str = fName[fName.count]+str
					fName = subString fName 1 (fName.count-1)
				)
				numStr = ((str as integer)+1) as string
			)
			if numStr.count < 2 then numStr = "0" + numStr
			(fPath + fName + numStr + fExt)
		) catch (undefined)
	)

	on execute do (
		local fName = getMajorIncFileName (maxFilePath+maxFileName)
		if fName == undefined OR (getFiles fName).count != 0 then
			fName = getSaveFileName caption:"safeSave File As" filename:(maxFilePath+maxFileName) types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if (getFiles fName).count == 0 then (
			saveMaxFile fName
		) else (
			if NOT (getFileAttribute fName #readOnly) then
				saveMaxFile fName
			else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
		)
	)
)

------------------------------------------------------------------------------
-- safeSafe minor incremental macroscript
------------------------------------------------------------------------------
macroScript safeSaveIncMinor
	category: "safeSave"
	tooltip: "safeSave Minor Incremental (+)"
	buttonText: "safeSave(+)"
(
	fn toLowerCase str = (
		local lowerCase = "abcdefghijklmnopqrstuvwxyz"
		local upperCase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
		local outStr = ""
		for i = 1 to str.count do (
			local n = findString upperCase str[i]
			if n != undefined then outStr += lowerCase[n]
			else outStr += str[i]
		)
		outStr
	)
	
	fn getMinorIncFileName f = (
		try (
			local fName = getFilenameFile f
			local fExt = getFilenameType f
			local fPath = getFilenamePath f
			local digits = "0123456789"
			local letters = "abcdefghijklmnopqrstuvwxyz"
			local numStr = "01"
			try (
				local i = findString letters (toLowerCase fName[fName.count])
				if i != undefined AND findString digits fName[fName.count-1] != undefined then (
					if (i+=1) > letters.count then return undefined
					fName[fName.count] = letters[i]
					numStr = ""
				) else (
					if findString digits fName[fName.count] != undefined then
						numStr = letters[1]
				)
			)catch()
			(fPath + fName + numStr + fExt)
		)catch(undefined)
	)

	on execute do (
		local fName = getMinorIncFileName (maxFilePath+maxFileName)
		if fName == undefined OR (getFiles fName).count != 0 then
			fName = getSaveFileName caption:"safeSave File As" filename:(maxFilePath+maxFileName) types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if (getFiles fName).count == 0 then (
			saveMaxFile fName
		) else (
			if NOT (getFileAttribute fName #readOnly) then
				saveMaxFile fName
			else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
		)
	)
)

