--******************************************************************************
--*                                                                            *
--*  safeSave tools                   for Max 4.2                              *
--*  by Ofer Zelichover (c) 12/2001                                            *
--*  www.tdp.nu/ofer   ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--******************************************************************************
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a credit if you do so ;))                *
--******************************************************************************
--*  This script comes with no waranty!                                        *
--*  Although I tried this script and couldn't find any problems with it, I can*
--*  in no way be held responsible for any kind of loss or damage, whether     *
--*  direct or indirect, due to the use of this script.                        *
--*                                                                            *
--*  ********************************************************************      *
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***      *
--*  ********************************************************************      *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** versions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in this script, please let me know.                  *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--* Due to a bug in max 4.x it is possible to overwrite files that are marked  *
--* as read-only. safeSave tools are a set of tool to replace the max internal *
--* save functions, and solve this problem (until Discreet with fix it in      *
--* future versions of max).                                                   *
--* safeSave tools consists of four save tools:                                *
--* +safeSave - replaces the max save (file > save)                            *
--* +safeSaveAs - replaces the max save as (file > save as)                    *
--* +safeSaveSelected - replaces the max save selected (file > save selected)  *
--* +safeSaveIncremental - replaces the max save incremental (the + in save as)*
--* The tools are macroscripts so you can put assign them to button, keys or   *
--* quad options.                                                              *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* Created: 11/12/2001 - Ver 1.0                                              *
--*                                                                            *
--* Known issues:                                                              *
--*                                                                            *
--* Need to add:                                                               *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*         safeSave.ms      - anywhere                                        *
--*                                                                            *
--*  After you run safeSave.ms, the safeSave tools will appear in the          *
--*  "safeSave" category in the customize ui menu.                             *
--*                                                                            *
--******************************************************************************


--***************************************************************
-- Start of macroScripts
--***************************************************************

-- safeSafe macroscript
macroScript safeSave
	category: "safeSave"
	tooltip: "safeSave"
	buttonText: "safeSave"
(
	on execute do (
		if NOT (getFileAttribute (maxFilePath+maxFileName) #readOnly) then
			saveMaxFile (maxFilePath+maxFileName)
		else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
	)
)

-- safeSafe as macroscript
macroScript safeSaveAs
	category: "safeSave"
	tooltip: "safeSave As"
	buttonText: "safeSaveAs"
(
	on execute do (
		local fName = getSaveFileName caption:"safeSave File As" filename:(maxFilePath+maxFileName) types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if NOT (getFileAttribute fName #readOnly) then
			saveMaxFile fName
		else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
	)
)

-- safeSafe selected macroscript
macroScript safeSaveSelected 
	category: "safeSave"
	tooltip: "safeSave Selected"
	buttonText: "safeSave Selected"
(
	on isEnabled return (selection.count>0)
	
	on execute do (
		if selection.count == 0 then return()
		local fName = getSaveFileName caption:"safeSave File As" types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if NOT (getFileAttribute fName #readOnly) then
			saveNodes selection fName
		else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"	
	)
)


-- safeSafe incremental macroscript
macroScript safeSaveIncremental
	category: "safeSave"
	tooltip: "safeSave Incremental (+)"
	buttonText: "safeSave Inc(+)"
(
	fn getIncFileName f = (
		local fName = getFilenameFile f
		local fExt = getFilenameType f
		local fPath = getFilenamePath f
		local digits = "0123456789"
		local numStr = "01"
		if findString digits fName[fName.count] != undefined then (
			local str = ""
			while (findString digits fName[fName.count] != undefined) do (
				str = fName[fName.count]+str
				fName = subString fName 1 (fName.count-1)
			)
			numStr = ((str as integer)+1) as string
		)
		if numStr.count < 2 then numStr = "0" + numStr
		(fPath + fName + numStr + fExt)
	)

	on execute do (
		local fName = getIncFileName (maxFilePath+maxFileName)
		if (getFiles fName).count != 0 then
			fName = getSaveFileName caption:"safeSave File As" filename:(maxFilePath+maxFileName) types:"3ds max (*.max)|*.max" 
		if fName == undefined then return()
		if (getFiles fName).count == 0 then (
			saveMaxFile fName
		) else (
			if NOT (getFileAttribute fName #readOnly) then
				saveMaxFile fName
			else messageBox "Could not save.\nFile is marked as read-only." title:"safeSave"
		)
	)
)

