--******************************************************************************
--*                                                                            *
--*  paintSelect v1.1                 for Max 4.2                              *
--*  by Ofer Zelichover (c) 01/2002                                            *
--*  www.tdp.nu/ofer   ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--******************************************************************************
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a credit if you do so ;))                *
--******************************************************************************
--*  This script comes with no waranty!                                        *
--*  Although I tried this script and couldn't find any problems with it, I can*
--*  in no way be held responsible for any kind of loss or damage, whether     *
--*  direct or indirect, due to the use of this script.                        *
--*                                                                            *
--*  ********************************************************************      *
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***      *
--*  ********************************************************************      *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** versions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in this script, please let me know.                  *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--* Select sub-objects of mesh and poly objects by "painting" with a variable  *
--* sized brush.                                                               *
--*                                                                            *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* Created: 04/02/2002 - Ver 1.0                                              *
--*   07/02/2002 - Ver 1.1                                                     *
--*   - Changed the dialog to take less screen space.                          *
--*   - The dialog now "remembers" last position.                              *
--*   - Added help.                                                            *
--*                                                                            *
--* Known issues:                                                              *
--*                                                                            *
--* Need to add:                                                               *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*         paintSelect-v1.ms     - anywhere                                   *
--*                                                                            *
--*  After you run the script, the paintSelect tool will apear in the          *
--*  "Os Tools" category in the customize ui menu.                             *
--*                                                                            *
--******************************************************************************


--***************************************************************
-- Start of macroScripts
--***************************************************************

macroscript paintSelect
	category:"Os Tools"
	tooltip:"paintSelect"
	buttontext:"paintSelect"
(
-- Struct Declerations
------------------------
	struct struct_paintSelectSettings (brushSize, pos)

-- Global Variables Decleration
---------------------------------
	global paintSelectSettings
	global paintSelectRoll

-- Local Variables Decleration
--------------------------------
	local paintSelectBrush
	local resizeBrushStartPos
	
------------------------------------------------------------------
-- define the rollout
-------------------------
	rollout paintSelectRoll "paintSelect 1.1"
	(
	-- Local Function Decleratons
	------------------------------
		local genIcon
	
	-- Local Variable Declerations
	--------------------------------
		local r = if paintSelectSettings!=undefined then paintSelectSettings.brushSize else 10
		local dragMode = false
		local prevMousePos = [0,0]
-- define the help message:
		local helpMessage ="
                                                     paintSelect v1.1
                                        by Ofer Zelichover (c) 02/2002
                          http://www.tdp.nu/ofer           ofer_z@hotmail.com


   Usage:
-------------------
Use paintSelect to select sub-objects by \"painting\" on the object.
Set the brush size using the paintSelect dialog.
You can also set the brush size by holding down Ctrl + Shift + Left mouse button.
Use left mouse button to select.
Hold Ctrl key while selecting to add to selection.
Hold Alt key while selecting to subtract from selection.
Use right mouse button to end paintSelect.

You can use soft selection (where aplicable) using Max's built-in soft-selection.


====================================================


You may use this script freely as you see fit.
You may use parts or the script as a whole in your own scripts.
(it would be nice if you give me a credit if you do so ;))

This script comes with no waranty!
Although I tried this script and couldn't find any problems with it, I can
in no way be held responsible for any kind of loss or damage, whether
direct or indirect, due to the use of this script.

**********************************************************************
*** IF YOU DON'T LIKE THE ABOVE STATEMENT, PLAESE DON'T USE THIS SCRIPT ***
**********************************************************************

This script was written for max 4.2 and wasn't tested on other versions of max.

If you find any bugs in this script, please let me know.

" -- end of helpMessage text
		local qMarkIcon = #(#{},#{3..6},#{2..7},#{2..3,6..7},#{6..7},#{5..6},#{4..5},#{},#{4..5},#{})
		local qMarkBM = genIcon 8 10 qMarkIcon black white
		local closeIcon = #(#{},#{2,7},#{2..3,6..7},#{3..6},#{4..5},#{4..5},#{3..6},#{2..3,6..7},#{2,7},#{})
		local closeBM = genIcon 8 10 closeIcon black white
		
	-- GUI
	---------
		groupBox titleGrp width:105 height:23 pos:[0,-6]
		button psHelp images:#(qMarkBM,qMarkBM,1,1,1,1,1) width:11 height:13 pos:[80,2] tooltip:"Help"
		button psClose images:#(closeBM,closeBM,1,1,1,1,1) width:11 height:13 pos:[92,2] tooltip:"Close Dialog"
		label psTitle "paintSelect 1.1" pos:[2,2]
		spinner brushSize "Brush size:" fieldWidth:35 range:[1,50,r] type:#integer align:#left offset:[-10,-2]
		
		
	-- Functions
	----------------
	fn isInTitle pos = (
		--upper left corner
		local tpUL = [titleGrp.pos.x,titleGrp.pos.y+6] 
		--lower right corner
		local tpLR = [titleGrp.pos.x+titleGrp.width-1,titleGrp.pos.y+titleGrp.height-1] 
		pos.x>=tpUL.x AND pos.y>=tpUL.y AND pos.x<=tpLR.x AND pos.y<=tpLR.y
	)
		
	fn genIcon w h data col bkCol = (
		local b = bitmap w h color:bkCol
		for y = 0 to h-1 do (
			local row = #()
			for x = 1 to w do (
				local c = if data[y+1][x] then col else bkCol
				append row c
			)
			setPixels b [0,y] row
		)
		b
	)
	-- Event Handlers
	-------------------
		on brushSize changed value do (
			try (
				paintSelectBrush.radius = value
				if paintSelectSettings!=undefined then paintSelectSettings.brushSize = value
			)catch()
		)

		on psHelp pressed do (
			messageBox helpMessage title:("About paintSelect 1.1") beep:false
		)

		on psClose pressed do (
			try (destroyDialog paintSelectRoll)catch()
		)

		on paintSelectRoll lButtonDown pos do (
			dragMode = isInTitle pos
			if dragMode then prevMousePos = pos
		)
		on paintSelectRoll lButtonUp pos do (
			dragMode = false
		)
		on paintSelectRoll mouseMove pos do (
			if dragMode then (
				newPos = ((getDialogPos paintSelectRoll)+(pos-prevMousePos))
				setDialogPos paintSelectRoll newPos
			)
		)

		on paintSelectRoll close do (
			if paintSelectSettings!=undefined then paintSelectSettings.pos = getDialogPos paintSelectRoll
			freeSceneBitmaps()
		)
	)-- end of rollout definition.
	
------------------------------------------------------------------
-- Macroscript Functions
----------------------------
-- Functions to get the vertex paint of mesh objects
	fn getMeshVertsInRadius obj pos face r faceList = (
		append faceList face
		local verts = #{}
		local tmpVerts = meshop.getVertsUsingFace obj face
		for v in tmpVerts where (distance (meshop.getVert obj v) pos <= r) do (
			append verts v
			local tmpFaces = meshop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				verts += (getMeshVertsInRadius obj pos f r faceList)
			)
		)
		verts
	)
	
	fn getMeshEdgesInRadius obj pos face r faceList = (
		append faceList face
		local edges = #{}
		local tmpEdges = meshop.getEdgesUsingFace obj face
		for e in tmpEdges do (
			local tmpVerts = (meshop.getVertsUsingEdge obj e) as array
			if ((distance (meshop.getVert obj tmpVerts[1]) pos <= r) AND \
					(distance (meshop.getVert obj tmpVerts[2]) pos <= r)) then (
				append edges e
				local tmpFaces = meshop.getFacesUsingVert obj tmpVerts
				for f in tmpFaces where (NOT faceList[f]) do (
					append faceList f
					edges += (getMeshEdgesInRadius obj pos f r faceList)
				)
			)
		)
		edges
	)

	fn getMeshFacesInRadius obj pos face r faceList = (
		append faceList face
		local faces = #{}
		local tmpVerts = meshop.getVertsUsingFace obj face
		for v in tmpVerts do (
			local tmpFaces = meshop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				if (distance (meshop.getFaceCenter obj f) pos <= r) then (
					append faces f
					faces += (getMeshFacesInRadius obj pos f r faceList)
				)
			)
		)
		faces
	)
	

	fn getMeshSOInRadius obj pos face r faceList = (
		case subObjectLevel of (
			1: getMeshVertsInRadius obj pos face r faceList
			2: getMeshEdgesInRadius obj pos face r faceList
			3: getMeshFacesInRadius obj pos face r faceList
			4: getMeshFacesInRadius obj pos face r faceList
			default: #{}
		)
	)
--------------------------------------------------------------------
-- Functions to get the vertex paint of poly objects
-- this function returns a face close to the intersectin point of the object and the cursor.
	fn getPolyFaceByPos obj pos r = (
		for i = 1 to polyop.getNumFaces obj where (distance (polyop.getFaceCenter obj i) pos <= r) do
			return i
		undefined
	)

	fn getPolyVertsInRadius obj pos face r faceList = (
		append faceList face
		local verts = #{}
		local tmpVerts = polyop.getVertsUsingFace obj face
		for v in tmpVerts where (distance (polyop.getVert obj v) pos <= r) do (
			append verts v
			local tmpFaces = polyop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				verts += (getPolyVertsInRadius obj pos f r faceList)
			)
		)
		verts
	)

	fn getPolyEdgesInRadius obj pos face r faceList = (
		append faceList face
		local edges = #{}
		local tmpEdges = polyop.getEdgesUsingFace obj face
		for e in tmpEdges do (
			local tmpVerts = (polyop.getVertsUsingEdge obj e) as array
			if ((distance (polyop.getVert obj tmpVerts[1]) pos <= r) AND \
					(distance (polyop.getVert obj tmpVerts[2]) pos <= r)) then (
				append edges e
				local tmpFaces = polyop.getFacesUsingEdge obj e
				for f in tmpFaces where (NOT faceList[f]) do (
					append faceList f
					edges += (getPolyEdgesInRadius obj pos f r faceList)
				)
			)
		)
		edges
	)

	fn getPolyFacesInRadius obj pos face r faceList = (
		append faceList face
		local faces = #{}
		local tmpVerts = polyop.getVertsUsingFace obj face
		for v in tmpVerts do (
			local tmpFaces = polyop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				if (distance (polyop.getFaceCenter obj f) pos <= r) then (
					append faces f
					faces += (getPolyFacesInRadius obj pos f r faceList)
				)
			)
		)
		faces
	)
	
	fn getPolySOInRadius obj pos face r faceList = (
		case subObjectLevel of (
			1: getPolyVertsInRadius obj pos face r faceList
			2: getPolyEdgesInRadius obj pos face r faceList
			3: #{}
			4: getPolyFacesInRadius obj pos face r faceList
			default: #{}
		)
	)

-----------------------------------------------------------------------------	
-- the next 2 functions check the subobject level and perform the appropriate
-- operation for mesh objects
	fn getMeshSubObjSelection obj = (
		case subObjectLevel of (
			1: getVertSelection obj
			2: getEdgeSelection obj
			3: getFaceSelection obj
			4: getFaceSelection obj
			default: #{}
		)
	)
	
	fn setMeshSubObjSelection obj sel keep:false = (
		if modPanel.getCurrentObject()==obj.baseObject then (
			case subObjectLevel of (
				1: setVertSelection obj sel keep:keep
				2: setEdgeSelection obj sel keep:keep
				3: setFaceSelection obj sel keep:keep
				4: setFaceSelection obj sel keep:keep
			)
		) else (
			case subObjectLevel of (
				1: setVertSelection obj (modPanel.getCurrentObject()) sel keep:keep
				2: setEdgeSelection obj (modPanel.getCurrentObject()) sel keep:keep
				3: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
				4: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
			)
		)
	)
	
-- the next 2 functions check the subobject level and perform the appropriate
-- operation for poly objects
	fn getPolySubObjSelection obj = (
		case subObjectLevel of (
			1: polyop.getVertSelection obj
			2: polyop.getEdgeSelection obj
			3: polyop.getFaceSelection obj
			4: polyop.getFaceSelection obj
			default: #{}
		)
	)
	
	fn setPolySubObjSelection obj sel keep:false = (
		if modPanel.getCurrentObject()==obj.baseObject then (
			case subObjectLevel of (
				1: polyop.setVertSelection obj sel
				2: polyop.setEdgeSelection obj sel
				3: polyop.setFaceSelection obj sel
				4: polyop.setFaceSelection obj sel
			)
			update obj
		) else (
			case subObjectLevel of (
				1: setVertSelection obj (modPanel.getCurrentObject()) sel keep:keep
				2: setEdgeSelection obj (modPanel.getCurrentObject()) sel keep:keep
				3: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
				4: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
			)
		)
	)

------------------------------------------------------------------
-- the main pain function.
-- this function is called from the mouseTrack function.
	fn paintSelect msg ir obj faceNum shift ctrl alt = (
		disableSceneRedraw()
		local brush = paintSelectBrush
		local resizeBrushMode = (shift AND ctrl)
		
		if NOT resizeBrushMode then (
			try (brush.pos = ir.pos) catch()
			try (brush.dir = ir.dir) catch()
			resizeBrushStartPos = undefined
		)
		brush.scale = [1,1,1]*((getScreenScaleFactor brush.pos)/100.)
	
		if (msg == #mouseMove OR msg == #mousePoint) AND NOT (shift AND ctrl) then (
			local r = brush.radius * brush.scale.x
			local curSel = #{}
			local newSel = #{}
			local keep = false
			
			if classOf obj == Editable_mesh then (
				curSel = getMeshSubObjSelection obj
 				newSel = if ir!=undefined then (getMeshSOInRadius obj ir.pos faceNum r #{}) else #{}
				if alt then newSel = curSel - newSel
				if ctrl then keep = true
				setMeshSubObjSelection obj newSel keep:keep
			)
			if classOf obj == Editable_poly OR classOf obj == PolyMeshObject then (
				curSel = getPolySubObjSelection obj
 				newSel = #{}
				if ir!=undefined then (
					faceNum = getPolyFaceByPos obj ir.pos r
					if faceNum != undefined then 
						newSel = (getPolySOInRadius obj ir.pos faceNum r #{})
				) 
				if alt then newSel = curSel - newSel
				if ctrl then (
					newSel = curSel + newSel
					keep = true
				)
				setPolySubObjSelection obj newSel keep:keep
			)
		)

		if resizeBrushMode AND (msg == #mouseMove OR msg == #mousePoint) then (
			if resizeBrushStartPos == undefined then
				try(resizeBrushStartPos = ir.pos)catch(resizeBrushStartPos = [0,0])
			local r = try (gw.getCPDisp brush.pos brush.dir resizeBrushStartPos ir.pos)catch(brush.radius)
			r = abs (r as integer)
			if r <= 1 then r = 1
			if r >= 50 then r = 50
			brush.radius = r
			try (paintSelectRoll.brushSize.value = r)catch()
			if paintSelectSettings!=undefined then paintSelectSettings.brushSize = r
		)

		enableSceneRedraw()
		if msg != #mouseAbort then #continue
	)
	
	fn isMacroscriptEnabled = (
		local c = classOf selection[1]
		selection.count == 1 AND subObjectLevel > 0 AND \
		(c==Editable_mesh OR c==Editable_poly OR c==PolyMeshObject)
	)
--------------------------------------------------------------------------
-- event handlers
---------------------
	on isVisible return isMacroscriptEnabled()

	on isEnabled return isMacroscriptEnabled()

	on execute do (
		if paintSelectSettings == undefined then
			paintSelectSettings = struct_paintSelectSettings 10.0 [10,100]
		local r = paintSelectSettings.brushSize
		local dlgPos = paintSelectSettings.pos
		try (destroyDialog paintSelectRoll)catch()
		paintSelectBrush = circle name:"paintSelectBrush" radius:r wireColor:(color 230 230 0)
		createDialog paintSelectRoll pos:dlgPos width:105 height:30 style:#(#style_border)
		local obj = selection[1]
--		local promptMessage = "paintSelect: LMB=Select; ctrl+LMB=Add; alt+LMB=Subtract; RMB=exit;"
		mouseTrack on:obj prompt:"" trackCallback:paintSelect
		delete paintSelectBrush
		paintSelectBrush = undefined
		try (destroyDialog paintSelectRoll)catch()
		enableSceneRedraw()
	)
	
)-- end of macroscript	

