--******************************************************************************
--*                                                                            *
--*  safeSave tools v1.0              for Max 4.2                              *
--*  by Ofer Zelichover (c) 01/2002                                            *
--*  www.tdp.nu/ofer   ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--******************************************************************************
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a credit if you do so ;))                *
--******************************************************************************
--*  This script comes with no waranty!                                        *
--*  Although I tried this script and couldn't find any problems with it, I can*
--*  in no way be held responsible for any kind of loss or damage, whether     *
--*  direct or indirect, due to the use of this script.                        *
--*                                                                            *
--*  ********************************************************************      *
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***      *
--*  ********************************************************************      *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** versions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in this script, please let me know.                  *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--* Select sub-objects of mesh and poly objects by "painting" with a variable  *
--* sized brush.                                                               *
--*                                                                            *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* Created: 04/01/2002 - Ver 1.0                                              *
--*                                                                            *
--* Known issues:                                                              *
--*                                                                            *
--* Need to add:                                                               *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*         paintSelect-v1.ms     - anywhere                                   *
--*                                                                            *
--*  After you run the script, the paintSelect tool will apear in the          *
--*  "Os Tools" category in the customize ui menu.                             *
--*                                                                            *
--******************************************************************************


--***************************************************************
-- Start of macroScripts
--***************************************************************

macroscript paintSelect
	category:"Os Tools"
	tooltip:"paintSelect"
	buttontext:"paintSelect"
(
-- Struct Declerations
------------------------
	struct struct_paintSelectSettings (brushSize)

-- Global Variables Decleration
---------------------------------
	global paintSelectSettings
	global paintSelectRoll

-- Local Variables Decleration
--------------------------------
	local paintSelectBrush
	
------------------------------------------------------------------
-- define the rollout
-------------------------
	rollout paintSelectRoll "paintSelect" 
	(
		local r = if paintSelectSettings!=undefined then paintSelectSettings.brushSize else 10
		spinner brushSize "Brush size:" fieldWidth:35 range:[1,50,r] type:#integer align:#left
		
		on brushSize changed value do (
			try (
				paintSelectBrush.radius = value
				if paintSelectSettings!=undefined then paintSelectSettings.brushSize = value
			)catch()
		)
	)-- end of rollout definition.
	
------------------------------------------------------------------
-- Macroscript Functions
----------------------------
-- Functions to get the vertex paint of mesh objects
	fn getMeshVertsInRadius obj pos face r faceList = (
		append faceList face
		local verts = #{}
		local tmpVerts = meshop.getVertsUsingFace obj face
		for v in tmpVerts where (distance (meshop.getVert obj v) pos <= r) do (
			append verts v
			local tmpFaces = meshop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				verts += (getMeshVertsInRadius obj pos f r faceList)
			)
		)
		verts
	)
	
	fn getMeshEdgesInRadius obj pos face r faceList = (
		append faceList face
		local edges = #{}
		local tmpEdges = meshop.getEdgesUsingFace obj face
		for e in tmpEdges do (
			local tmpVerts = (meshop.getVertsUsingEdge obj e) as array
			if ((distance (meshop.getVert obj tmpVerts[1]) pos <= r) AND \
					(distance (meshop.getVert obj tmpVerts[2]) pos <= r)) then (
				append edges e
				local tmpFaces = meshop.getFacesUsingVert obj tmpVerts
				for f in tmpFaces where (NOT faceList[f]) do (
					append faceList f
					edges += (getMeshEdgesInRadius obj pos f r faceList)
				)
			)
		)
		edges
	)

	fn getMeshFacesInRadius obj pos face r faceList = (
		append faceList face
		local faces = #{}
		local tmpVerts = meshop.getVertsUsingFace obj face
		for v in tmpVerts do (
			local tmpFaces = meshop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				if (distance (meshop.getFaceCenter obj f) pos <= r) then (
					append faces f
					faces += (getMeshFacesInRadius obj pos f r faceList)
				)
			)
		)
		faces
	)
	

	fn getMeshSOInRadius obj pos face r faceList = (
		case subObjectLevel of (
			1: getMeshVertsInRadius obj pos face r faceList
			2: getMeshEdgesInRadius obj pos face r faceList
			3: getMeshFacesInRadius obj pos face r faceList
			4: getMeshFacesInRadius obj pos face r faceList
			default: #{}
		)
	)
--------------------------------------------------------------------
-- Functions to get the vertex paint of poly objects
-- this function returns a face close to the intersectin point of the object and the cursor.
	fn getPolyFaceByPos obj pos r = (
		for i = 1 to polyop.getNumFaces obj where (distance (polyop.getFaceCenter obj i) pos <= r) do
			return i
		undefined
	)

	fn getPolyVertsInRadius obj pos face r faceList = (
		append faceList face
		local verts = #{}
		local tmpVerts = polyop.getVertsUsingFace obj face
		for v in tmpVerts where (distance (polyop.getVert obj v) pos <= r) do (
			append verts v
			local tmpFaces = polyop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				verts += (getPolyVertsInRadius obj pos f r faceList)
			)
		)
		verts
	)

	fn getPolyEdgesInRadius obj pos face r faceList = (
		append faceList face
		local edges = #{}
		local tmpEdges = polyop.getEdgesUsingFace obj face
		for e in tmpEdges do (
			local tmpVerts = (polyop.getVertsUsingEdge obj e) as array
			if ((distance (polyop.getVert obj tmpVerts[1]) pos <= r) AND \
					(distance (polyop.getVert obj tmpVerts[2]) pos <= r)) then (
				append edges e
				local tmpFaces = polyop.getFacesUsingEdge obj e
				for f in tmpFaces where (NOT faceList[f]) do (
					append faceList f
					edges += (getPolyEdgesInRadius obj pos f r faceList)
				)
			)
		)
		edges
	)

	fn getPolyFacesInRadius obj pos face r faceList = (
		append faceList face
		local faces = #{}
		local tmpVerts = polyop.getVertsUsingFace obj face
		for v in tmpVerts do (
			local tmpFaces = polyop.getFacesUsingVert obj v 
			for f in tmpFaces where (NOT faceList[f]) do (
				append faceList f
				if (distance (polyop.getFaceCenter obj f) pos <= r) then (
					append faces f
					faces += (getPolyFacesInRadius obj pos f r faceList)
				)
			)
		)
		faces
	)
	
	fn getPolySOInRadius obj pos face r faceList = (
		case subObjectLevel of (
			1: getPolyVertsInRadius obj pos face r faceList
			2: getPolyEdgesInRadius obj pos face r faceList
			3: #{}
			4: getPolyFacesInRadius obj pos face r faceList
			default: #{}
		)
	)

-----------------------------------------------------------------------------	
-- the next 2 functions check the subobject level and perform the appropriate
-- operation for mesh objects
	fn getMeshSubObjSelection obj = (
		case subObjectLevel of (
			1: getVertSelection obj
			2: getEdgeSelection obj
			3: getFaceSelection obj
			4: getFaceSelection obj
			default: #{}
		)
	)
	
	fn setMeshSubObjSelection obj sel keep:false = (
		if modPanel.getCurrentObject()==obj.baseObject then (
			case subObjectLevel of (
				1: setVertSelection obj sel keep:keep
				2: setEdgeSelection obj sel keep:keep
				3: setFaceSelection obj sel keep:keep
				4: setFaceSelection obj sel keep:keep
			)
		) else (
			case subObjectLevel of (
				1: setVertSelection obj (modPanel.getCurrentObject()) sel keep:keep
				2: setEdgeSelection obj (modPanel.getCurrentObject()) sel keep:keep
				3: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
				4: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
			)
		)
	)
	
-- the next 2 functions check the subobject level and perform the appropriate
-- operation for poly objects
	fn getPolySubObjSelection obj = (
		case subObjectLevel of (
			1: polyop.getVertSelection obj
			2: polyop.getEdgeSelection obj
			3: polyop.getFaceSelection obj
			4: polyop.getFaceSelection obj
			default: #{}
		)
	)
	
	fn setPolySubObjSelection obj sel keep:false = (
		if modPanel.getCurrentObject()==obj.baseObject then (
			case subObjectLevel of (
				1: polyop.setVertSelection obj sel
				2: polyop.setEdgeSelection obj sel
				3: polyop.setFaceSelection obj sel
				4: polyop.setFaceSelection obj sel
			)
			update obj
		) else (
			case subObjectLevel of (
				1: setVertSelection obj (modPanel.getCurrentObject()) sel keep:keep
				2: setEdgeSelection obj (modPanel.getCurrentObject()) sel keep:keep
				3: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
				4: setFaceSelection obj (modPanel.getCurrentObject()) sel keep:keep
			)
		)
	)

------------------------------------------------------------------
-- the main pain function.
-- this function is called from the mouseTrack function.
	fn paintSelect msg ir obj faceNum shift ctrl alt = (
		disableSceneRedraw()
		local brush = paintSelectBrush
		try (brush.pos = ir.pos) catch()
		try (brush.dir = ir.dir) catch()
		brush.scale = [1,1,1]*((getScreenScaleFactor brush.pos)/100.)
	
		if msg == #mouseMove OR msg == #mousePoint then (
			local r = brush.radius * brush.scale.x
			local curSel = #{}
			local newSel = #{}
			local keep = false
			
			if classOf obj == Editable_mesh then (
				curSel = getMeshSubObjSelection obj
 				newSel = if ir!=undefined then (getMeshSOInRadius obj ir.pos faceNum r #{}) else #{}
				if alt then newSel = curSel - newSel
				if ctrl then keep = true
				setMeshSubObjSelection obj newSel keep:keep
			)
			if classOf obj == Editable_poly OR classOf obj == PolyMeshObject then (
				curSel = getPolySubObjSelection obj
 				newSel = #{}
				if ir!=undefined then (
					faceNum = getPolyFaceByPos obj ir.pos r
					if faceNum != undefined then 
						newSel = (getPolySOInRadius obj ir.pos faceNum r #{})
				) 
				if alt then newSel = curSel - newSel
				if ctrl then (
					newSel = curSel + newSel
					keep = true
				)
				setPolySubObjSelection obj newSel keep:keep
			)
		)
	
		enableSceneRedraw()
		if msg != #mouseAbort then #continue
	)
	
	fn isMacroscriptEnabled = (
		local c = classOf selection[1]
		selection.count == 1 AND subObjectLevel > 0 AND \
		(c==Editable_mesh OR c==Editable_poly OR c==PolyMeshObject)
	)
--------------------------------------------------------------------------
-- event handlers
---------------------
	on isVisible return isMacroscriptEnabled()

	on isEnabled return isMacroscriptEnabled()

	on execute do (
		if paintSelectSettings == undefined then
			paintSelectSettings = struct_paintSelectSettings 10.0
		local r = paintSelectSettings.brushSize
		try (destroyDialog paintSelectRoll)catch()
		paintSelectBrush = circle name:"paintSelectBrush" radius:r wireColor:(color 230 230 0)
		createDialog paintSelectRoll pos:[10,100] width:130 style:#(#style_toolWindow, #style_sysMenu)
		local obj = selection[1]
		local promptMessage = "paintSelect: LMB=Select; ctrl+LMB=Add; alt+LMB=Subtract; RMB=exit;"
		mouseTrack on:obj prompt:promptMessage trackCallback:paintSelect
		delete paintSelectBrush
		paintSelectBrush = undefined
		try (destroyDialog paintSelectRoll)catch()
		enableSceneRedraw()
	)
	
)-- end of macroscript	


---------------------------------------------------
-- old test, to use diferent way to do the paint.
--------------------------------------------------
--	local tm = inverse (viewport.getTM())
--	local dist = distance tm.row4 obj.pos
--	c.dir = tm.row3
--	c.pos = gw.mapCPToWorld (gw.getPointOnCP mouse.pos)
--	in coordsys c c.pos.z = tm.row4.z
