--******************************************************************************
--*                                                                            *
--*  delMinorVersions v1.0            for Max 4.2                              *
--*  by Ofer Zelichover (c) 01/2002                                            *
--*  www.tdp.nu/ofer   ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--******************************************************************************
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a credit if you do so ;))                *
--******************************************************************************
--*  This script comes with no waranty!                                        *
--*  Although I tried this script and couldn't find any problems with it, I can*
--*  in no way be held responsible for any kind of loss or damage, whether     *
--*  direct or indirect, due to the use of this script.                        *
--*                                                                            *
--*  ********************************************************************      *
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***      *
--*  ********************************************************************      *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** versions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in this script, please let me know.                  *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--*  This utility allows to easily delete minor versions that were created     *
--*  using the safeSave Minor Increment utility.                               *
--*                                                                            *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* Created: 31/01/2002 - Ver 1.0                                              *
--*                                                                            *
--* Known issues:                                                              *
--*                                                                            *
--* Need to add:                                                               *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*         delMinorVersions-v1.ms - anywhere                                  *
--*                                                                            *
--*  Just run the script.                                                      *
--*                                                                            *
--******************************************************************************

try(destroyDialog delMinorVersions)catch()

rollout delMinorVersions "Delete Minor Versions"
(
-- GUI
--------
	group "Base Flie: " (
		edittext baseFile ""  width:350 across:2
		button baseFileBrowse "Browse..." align:#right height:16
	)
	group "Minor Versions: " (
		multilistbox deleteFilesList "Delete Files: " width:200 height:20 align:#left across:2
		multilistbox keepFilesList "Keep Files: " width:200 height:20 align:#right
		button moveDeleteToKeep ">>" width:20 height:20 offset:[0,-170]
		button moveKeepToDelete "<<" width:20 height:20 offset:[0,10]
		button delFilesAll "All" height:16 width:50 pos:[15,365]
		button delFilesNone "None" height:16 width:50 pos:[88,365]
		button delFilesInvert "Invert" height:16 width:50 pos:[160,365]
		button keepFilesAll "All" height:16 width:50 pos:[240,365]
		button keepFilesNone "None" height:16 width:50 pos:[312,365]
		button keepFilesInvert "Invert" height:16 width:50 pos:[385,365]
	)
	
	button bnGo "Delete Minor Versions" pos:[50,395]
	button bnClose "Close" width:50 pos:[350,395]

-- Functions
-------------
-- Inverts the selection in a listbox
	fn selectionInvert sel = (
		#{1..sel.count}-sel
	)

	fn moveToKeep sel = (
		local newKeepList = keepFilesList.items
		local newDelList = deleteFilesList.items
		for i = newDelList.count to 1 by -1 where sel[i] do (
			append newKeepList newDelList[i]
			deleteItem newDelList i
		)
		keepFilesList.items = sort newKeepList
		deleteFilesList.items = sort newDelList
	)
	
	fn moveToDelete sel = (
		local newKeepList = keepFilesList.items
		local newDelList = deleteFilesList.items
		for i = newKeepList.count to 1 by -1 where sel[i] do (
			append newDelList newKeepList[i]
			deleteItem newKeepList i
		)
		keepFilesList.items = sort newKeepList
		deleteFilesList.items = sort newDelList
	)

	fn toLowerCase str = (
		local lowerCase = "abcdefghijklmnopqrstuvwxyz"
		local upperCase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
		local outStr = ""
		for i = 1 to str.count do (
			local n = findString upperCase str[i]
			if n != undefined then outStr += lowerCase[n]
			else outStr += str[i]
		)
		outStr
	)
	
	fn isMinorVersion f = (
		local fName = getFilenameFile f
		local digits = "0123456789"
		local letters = "abcdefghijklmnopqrstuvwxyz"
		local i = findString letters (toLowerCase fName[fName.count])
		(i != undefined) AND (findString digits fName[fName.count-1] != undefined)
	)

	fn isMajorVersion f = (
		local fName = getFilenameFile f
		local digits = "0123456789"
		findString digits fName[fName.count] != undefined
	)
	
	fn getStrippedFilename f = (
		try (
			local fName = getFilenameFile f
			local fExt = getFilenameType f
			local fPath = getFilenamePath f
			local digits = "0123456789"
			local letters = "abcdefghijklmnopqrstuvwxyz"
			try (
				if isMinorVersion fName then 
					fName = subString fName 1 (fName.count-1)
				if isMajorVersion fName then (
					while (findString digits fName[fName.count] != undefined) do
						fName = subString fName 1 (fName.count-1)
				)
			)catch()
			(fPath + fName + fExt)
		)catch("")
	)

	fn getFileNames baseName = (
		local basePath = getFilenamePath baseName
		local baseFilename = getFilenameFile baseName
		local baseExt = getFilenameType baseName
		local files = getFiles (basePath + getStrippedFilename baseFilename + "*" + baseExt)
		for i = files.count to 1 by -1 do (
			if isMinorVersion files[i] then
				files[i] = getFilenameFile files[i]
			else
				deleteItem files i
		)
		sort files
	)

	fn doDelete = (
		local fExt = getFilenameType baseFile.text
		local fPath = getFilenamePath baseFile.text
		local i = 0
		if fExt == "" then fExt = ".max"
		for f in deleteFilesList.items do (
			format "Deleting file: %\n" (fPath + f + fExt)
			if deleteFile (fPath + f + fExt) then
				i += 1
		)
		messageBox ("Deleted "+i as string+" files.") title:"Finished Deleting."
	)


-- Event Handlers
------------------
	on baseFile entered text do (
		local f = getStrippedFilename text
		baseFile.text = f
		deleteFilesList.items = getFileNames f
		keepFilesList.items = #()
	)
	on baseFileBrowse pressed do(
		local f = getOpenFileName caption:"Select Base File" types:"MAX Files|*.max|All Files|*.*"
		if f != undefined then (
			baseFile.text = getStrippedFilename f
			deleteFilesList.items = getFileNames f
			keepFilesList.items = #()
		)
	)

	on deleteFilesList doubleClicked sel do (
		local fExt = getFilenameType (baseFile.text)
		local fPath = getFilenamePath (baseFile.text)
		if fExt == "" then fExt = ".max"
		local f = fPath + getStrippedFilename (deleteFilesList.items[sel]) + fExt
		baseFile.text = f
		deleteFilesList.items = getFileNames f
		keepFilesList.items = #()
	)

	on keepFilesList doubleClicked sel do (
		local fExt = getFilenameType (baseFile.text)
		local fPath = getFilenamePath (baseFile.text)
		if fExt == "" then fExt = ".max"
		local f = fPath + getStrippedFilename (deleteFilesList.items[sel]) + fExt
		baseFile.text = f
		deleteFilesList.items = getFileNames f
		keepFilesList.items = #()
	)


	on moveDeleteToKeep pressed do (
		moveToKeep deleteFilesList.selection
		deleteFilesList.selection = #{}
	)
	on moveKeepToDelete pressed do (
		moveToDelete keepFilesList.selection
		keepFilesList.selection = #{}
	)
	on delFilesAll pressed do (deleteFilesList.selection=#{1..deleteFilesList.items.count})
	on delFilesNone pressed do (deleteFilesList.selection=#{})
	on delFilesInvert pressed do (deleteFilesList.selection=selectionInvert deleteFilesList.selection)
	on keepFilesAll pressed do (keepFilesList.selection=#{1..keepFilesList.items.count})
	on keepFilesNone pressed do (keepFilesList.selection=#{})
	on keepFilesInvert pressed do (keepFilesList.selection=selectionInvert keepFilesList.selection)
	
	on bnGo pressed do (
		if (queryBox "Delete minor versions (no undo!)?" title:"Delete Minor Versions") then (
			doDelete()
			deleteFilesList.items = getFileNames (getStrippedFilename baseFile.text)
			keepFilesList.items = #()
		)
	)
	on bnClose pressed do (destroyDialog delMinorVersions)

) -- end delMinorVersions rollout

createDialog delMinorVersions 450 420