-- Typer v0.31 last changed:9/9/2001
-- By Ofer Zelichover
-- You may freely use this script. Altough I had no problems with it, use it at your OWN RISK.
--*****************************************************************************************
-- Decription:
------------------
-- This utility creates a "typewriter" style text animation.
-- It also allows fade in instead of type-in. The user can controll the fade-in length
-- and the delay beteew letters. It also has bevel control and ability to assign material to
-- the text.
-- 
--**************************************************************************************
-- NOTE: ALTHOUGH I HAD NO PROBLEMS WITH THIS SCRIPT,
-- THIS SCRIPT IS NOT FULLY TESTED, THERE ARE STILL KNOWN ISSUES WITH THE TTFNAME UTIL 
-- (IT DOESN'T GET ALL FONTS) AND THERE IS ONLY BASIC FAULT CHECKING. 
--
-- I cannot be held responsible for any damage or loss caused by this script.
--**************************************************************************************
--
-- This script uses getFontNames which is an alternative to swami's script, 
-- it only comes to solve the issue of opening multiple
-- command windows. Hopefully, swami will make a better one soon.
--------------------------------------------------------------------------------------------------
-- Installation:
-----------------
-- Put : 	
--			Typer0_31.ms			- anywhere.
--			getFontNames-V0_3.ms 	- max scripts folder 
--			ttfname.exe				- max scripts folder
--			listfonts.bat			- max scripts folder
--			fontinfo.bat			- max scripts folder
--									
--********************************************************************************************



macroScript Typer

	category:"Os_Tools"
	tooltip:"Typer Utility"
	buttontext:"Typer"
(
local TyperFloater

include "C:\\3dsmax4\\Scripts\\getFontNames-v0_3.ms"-- getFontNames V0.3 12/8/2001


local createText
local init, done

-- Rollout Declarations
--======================
rollout typerText "Text Parameters"
(
-- GUI
-- ======
	dropdownlist textFont "Font: " items:#() selection:1
	checkbutton textItalic "Italic" checked:false highlightColor:(color 255 255 120) across:2 
	checkbutton textUnderline "Underline" checked:false highlightColor:(color 255 255 120)
	spinner textSize "Size: " range:[0,10000000000.0,100.0] type:#float 
	spinner textSpace "Letter spacing: " range:[-10000000000.0,10000000000.0,0.0] type:#float 
	edittext textText "Text: " text:"Text"
) -- End typerText Rollout

rollout typerAnim "Animation Parameters"
(
-- GUI
-- ======
	spinner animStartFrame "Start frame: " range:[0,1000000,0] type:#integer
	spinner animFadein "Fade in length(f): " range:[1,1000000,1] type:#integer
	spinner animDelay "Delay between letters(f): " range:[0,1000000,0] type:#integer

-- Event Handlers
-- ==================	
) -- End typerAnim Rollout
	
rollout typerBevel "Bevel Parameters"
(
	local enableBevelGUI
-- GUI
-- ======
	checkbox bevelEnabled "Bevel text" checked:false

	groupBox bevelCappingGrp "Capping: " enabled:false pos:[8,24] width:66 height:64
		checkbox bevelCapStart "Start" checked:true enabled:false pos:[14,44]
		checkbox bevelCapEnd "End" checked:true enabled:false pos:[14,62]

	groupBox bevelCapTypeGrp "Cap Type: " enabled:false pos:[78,24] width:66 height:64
		radiobuttons  bevelCapType "" labels:#("Morph","Grid") columns:1 enabled:false pos:[84,44]

	groupBox bevelCapIntersectionsGrp "Intersections: " enabled:false pos:[148,24] width:120 height:64
		checkbox bevelKeepLinesFromCrossing "Keep Lines From Crossing" checked:false enabled:false pos:[154,38] width:112 height:28
		spinner bevelSeperation "Seperation: " range:[0.01,10000000.0,1.0] type:#float enabled:false pos:[184,68] width:80

	groupBox bevelSurfaceGrp "Surface: " enabled:false pos:[8,88] width:260 height:88
		radiobuttons bevelSideType "" labels:#("Linear Sides","Curved Sides") columns:1 enabled:false pos:[14,104]
		spinner bevelSegments "Segments: " range:[1,100,1] type:#integer enabled:false pos:[160,112] width:96
		checkbox bevelSmoothLevels "Smooth Across Levels" checked:false enabled:false pos:[14,140]
		checkbox bevelMappingCoords "Generate Mapping Coords." checked:false enabled:false pos:[14,158]

	groupBox bevelValuesGrp "Bevel Values: " enabled:false pos:[8,180] width:260 height:166
		spinner bevelStartOutline "Start Outline: " range:[-10000000.0,10000000.0,0.0] type:#float enabled:false pos:[40,196] width:120
		label bevelLabel1 "Level 1: " pos:[14,220] enabled:false
		spinner bevelLevel1Height "Height: " range:[-10000000.0,10000000.0,0.0] type:#float enabled:false pos:[28,240] width:100
		spinner bevelLevel1Outline "Outline: " range:[-10000000.0,10000000.0,0.0] type:#float enabled:false pos:[164,240] width:100
		checkbox bevelUseLevel2 "Level 2: " checked:false enabled:false pos:[14,260]	
		spinner bevelLevel2Height "Height: " range:[-10000000.0,10000000.0,0.0] type:#float enabled:false pos:[28,280] width:100
		spinner bevelLevel2Outline "Outline: " range:[-10000000.0,10000000.0,0.0] type:#float enabled:false pos:[164,280] width:100
		checkbox bevelUseLevel3 "Level 3: " checked:false enabled:false pos:[14,300]	
		spinner bevelLevel3Height "Height: " range:[-10000000.0,10000000.0,0.0] type:#float enabled:false pos:[28,320] width:100
		spinner bevelLevel3Outline "Outline: " range:[-10000000.0,10000000.0,0.0] type:#float enabled:false pos:[164,320] width:100
		
-- Event Handlers
-- ==================
	on bevelEnabled changed state do enableBevelGUI state
	on bevelUseLevel2 changed state do (
		bevelLevel2Height.enabled = state
		bevelLevel2Outline.enabled = state
	)
	on bevelUseLevel3 changed state do (
		bevelLevel3Height.enabled = state
		bevelLevel3Outline.enabled = state
	)
	
-- Local Functions
-- =================
	fn enableBevelGUI enbl = (
		bevelCappingGrp.enabled = enbl
		bevelCapStart.enabled = enbl
		bevelCapEnd.enabled = enbl
		bevelCapTypeGrp.enabled = enbl
		bevelCapType.enabled = enbl
		bevelCapIntersectionsGrp.enabled = enbl
		bevelKeepLinesFromCrossing.enabled = enbl
		bevelSeperation.enabled = enbl
		bevelSurfaceGrp.enabled = enbl
		bevelSideType.enabled = enbl
		bevelSegments.enabled = enbl
		bevelSmoothLevels.enabled = enbl
		bevelMappingCoords.enabled = enbl
		bevelValuesGrp.enabled = enbl
		bevelStartOutline.enabled = enbl
		bevelLabel1.enabled = enbl
		bevelLevel1Height.enabled = enbl
		bevelLevel1Outline.enabled = enbl
		bevelUseLevel2.enabled = enbl
		bevelLevel2Height.enabled = (enbl and bevelUseLevel2.checked)
		bevelLevel2Outline.enabled = (enbl and bevelUseLevel2.checked)
		bevelUseLevel3.enabled = enbl
		bevelLevel3Height.enabled = (enbl and bevelUseLevel3.checked)
		bevelLevel3Outline.enabled = (enbl and bevelUseLevel3.checked)
	)
) --End typerBevel Rollout
	
rollout typerGrp "Object Creation"
(
-- GUI
-- ======
	group "Object Properties: " (
		edittext groupName "Name: " text:"Typer"
		materialbutton groupMat "Pick Material"
	)
	button go "Create animated text" width:150 height:30 across:2 offset:[10,0]
	button close "Close" offset:[20,5]

-- Event Handlers
-- ==================	
	on groupMat picked material do groupMat.text = groupMat.material.name
	on go pressed do (createText typerText.textText.text)
	on close pressed do done()
) -- End typerGrp Rollout


-- Global typer functions
--=============================
fn calcPos obj widthList =(
	local objWidth = (obj.max.x - obj.min.x)
	local xpos = 0.0
	local letterSpace = 0.05
	if typerText.textItalic.checked then letterSpace = -0.05
	for x in widthList do (
		if x != undefined then
			xpos += (x+typerText.textSize.value*letterSpace+typerText.textSpace.value)
	)
	xpos += (objWidth/2.0)
	return [xpos,0.0,0.0]
)

fn boolToInt bool = (if bool then return 1 else return 0)

fn addBevelModifier grp =(
	addModifier grp.children (bevel											\
		segments:typerBevel.bevelSegments.value			 					\
		Cap_Bottom:(boolToInt typerBevel.bevelCapStart.state)				\
		Cap_Top:(boolToInt typerBevel.bevelCapEnd.state)					\
		Cap_Type:typerBevel.bevelCapType.state								\
		Side_Type:typerBevel.bevelSideType.state							\
		Smooth_Levels:(boolToInt typerBevel.bevelSmoothLevels.state)		\
		Produce_Mapping_Coords:(boolToInt typerBevel.bevelMappingCoords.state)			\
		Keep_Lines_From_Crossing:(boolToInt typerBevel.bevelKeepLinesFromCrossing.state)\
		Separation_Between_Lines:typerBevel.bevelSeperation.value 			\
		Starting_Outline:typerBevel.bevelStartOutline.value					\
		Level_1_Height:typerBevel.bevelLevel1Height.value					\
		Level_1_Outline:typerBevel.bevelLevel1Outline.value					\
		Use_Level_2:(boolToInt typerBevel.bevelUseLevel2.state)				\
		Level_2_Height:typerBevel.bevelLevel2Height.value					\
		Level_2_Outline:typerBevel.bevelLevel2Outline.value					\
		Use_Level_3:(boolToInt typerBevel.bevelUseLevel3.state)				\
		Level_3_Height:typerBevel.bevelLevel3Height.value					\
		Level_3_Outline:typerBevel.bevelLevel3Outline.value	
	)
)

fn addModifiers grp =(
	if grp != undefined then (
		if not typerBevel.bevelEnabled.checked then
			addModifier grp.children (uvwmap())
		else
			addBevelModifier grp
	)
)
fn createLetter letter num widthList=(
	local t
	t = text name:(typerGrp.groupName.text+"_"+num as string) text:letter size:typerText.textSize.value \
			wirecolor:white italic:typerText.textItalic.checked underline:typerText.textUnderline.checked
	t.font = typerText.textFont.selected
	t.pos = (calcPos t widthList)
	t.material = typerGrp.groupMat.material
	local objWidth = 0.0
	if letter == " " then objWidth = (typerText.textSize.value*0.2)
		else objWidth = (t.max.x - t.min.x)
	append widthList objWidth
	return t
)

fn getStartFrame num = (
	local t = typerAnim.animStartFrame.value + (typerAnim.animDelay.value * (num-1))
	return t
)

fn getEndFrame num = (
	local t = (getStartFrame num) + typerAnim.animFadein.value
	return t
)

fn animateText obj num= (
	local k
	obj.visibility = bezier_float()
	local vis = obj.visibility.controller
	k = addNewKey vis (getStartFrame num)
	k.value = 0.0
	k = addNewKey vis (getEndFrame num)
	k.value = 1.0
	obj
)

fn createText textLine = (
	local widthList = #()
	local letterList = #()
	local l
	clearSelection()
	if textLine != undefined then
		for i = 1 to textLine.count do (
			l = (createLetter textLine[i] i widthList)
			append letterList l
			l = animateText l i
		)
	local grp = group letterList name:typerGrp.groupName.text select:true
	addModifiers grp
)

fn getFontNamesList forceUpd:false = (
	if  forceUpd or (fontNamesList == undefined) then
		return getFontNames()
	else 
		return fontNamesList
)

fn init = (
	-- create the floater window and add the rollouts
	if TyperFloater != undefined do (
		closerolloutfloater TyperFloater
	)
	TyperFloater = newRolloutFloater "Typer 0.31" 300 500 

	addRollout typerText TyperFloater 
	addRollout typerAnim TyperFloater
	addRollout typerBevel TyperFloater
	addRollout typerGrp TyperFloater 

	global fontNamesList = getFontNamesList()
	typerText.textFont.items=fontNamesList
)

fn done = (
	removeRollout typerGrp
	removeRollout typerText 
	removeRollout typerAnim
	closerolloutfloater TyperFloater
)

init()

) -- End of macroScript Typer.