-- scalePos v1.2
-- changed : v1.1 5/9/2001
-- fixed few minor bugs, add ability to use scaled object's center or pivot point.
--
-- changed : v1.2 2/10/2001
-- added undo (only one level of undo for now)
-- added support for coordinate systems
---------------------------------------------------------------------------------------------------
-- This utility scales the position of the selected objects using an object or the selection center
-- as the center of the scale.
-- Written by Ofer Zelichover. (c)2001.
-- You may freely distribute or change this script as you see fit.
---------------------------------------------------------------------------------------------------


utility scalePos "Scale Position" (
	local prevPos = #()
	local scaleAxes = [1.0,1.0,1.0]
	local coordSysItems = #("Screen","World","Parent","Local","Grid", \
							"------------------------------------","Pick","------------------------------------")
	local cpos = selection.center
	local undoEnabled = false
	local prevCoordsys = 2

-- GUI
-------
	group "Scale Center: " (
		radiobuttons cntr labels:#("Center of Selection","Object:")
		pickbutton cntrObj "Pick Center of Scale:" enabled:false tooltip:"Pick the object that will be the center point for scaling." message:"Pick the object that will be the center point for scaling."
	)
	
	group "Scale Reference: " (
		label lbl01 "Use scaled object's:" align:#left
		radiobuttons relative labels:#("Pivot Point","Center")
		label lbl02 "Reference Coordinate System: " align:#left offset:[-5,5]
		dropdownlist coordSysList "" items:coordSysItems selection:2
	)
	
	group "Scale Axes: "(
		checkbutton scaleX "X" checked:true across:3
		checkbutton scaleY "Y" checked:true
		checkbutton scaleZ "Z" checked:true
	)
	
	group "Distance Percentage: " (
		spinner scalePer range:[0.01,100000,100] type:#float scale:0.01 align:#center
	)

	button btUndo "Undo" enabled:undoEnabled

	group "About: " (
		label txt1 "Scale Position 1.2"
		label txt2 "Written by Ofer Zelichover."
		label txt3 "(c) 2001."
		
	)

-- Functions
--------------
	fn boolToInt bool = (if bool then return 1.0 else return 0.0)

	fn centerObj =(
		if cntrObj.object != undefined then (
			cntrObj.caption = cntrObj.object.name
			return cntrObj.object.pos
		)
		else return selection.center
	)

	fn changeCenter n =(
		case n of (
			1: (cpos = selection.center; cntrObj.enabled=false)
			2: (cpos = centerObj(); cntrObj.enabled=true)
		)
	)

	fn savePrevPos = (
		prevPos = #()
		for o in selection do
			case relative.state of (
				1:	append prevPos o.pos
				2:	append prevPos o.center
			)
	)
	
	fn scalePos origPos Cent Percent axes &pos= (
		local per = ((Percent - 100.0)/100.0)
		pos = origPos
		try (
			case coordSysList.selection of (
				1: (in coordsys screen pos+=((origPos - Cent) * Per * axes))
				2: (in coordsys world pos+=((origPos - Cent) * Per * axes))
				3: (in coordsys parent pos+=((origPos - Cent) * Per * axes))
				4: (in coordsys local pos+=((origPos - Cent) * Per * axes))
				5: (in coordsys grid pos+=((origPos - Cent) * Per * axes))
				6: (in coordsys world pos+=((origPos - Cent) * Per * axes))
				7: (in coordsys world pos+=((origPos - Cent) * Per * axes))
				8: (in coordsys world pos+=((origPos - Cent) * Per * axes))
				default: (
					obj = getNodeByName (coordSysList.items[coordSysList.selection])
					if obj == undefined then (in coordsys world pos+=((origPos - Cent) * Per * axes))
					else (in coordsys obj pos+=((origPos - Cent) * Per * axes))
				)
			)
		) catch()
	)

	fn rePos scaleDist cpos axes= (
		for i=1 to selection.count do (
			case relative.state of (
				1:	(scalePos prevPos[i] cpos scaleDist axes &selection[i].pos)
				2:	(scalePos prevPos[i] cpos scaleDist axes &selection[i].center)
			)
		)
	)

	fn undoScalePos = (
		if undoEnabled then (
			for i=1 to selection.count do (
				selection[i].pos = prevPos[i]
			)
			savePrevPos()
			undoEnabled = false
		)
	)

	fn changeCoordsys item = (
		case item of (
			6: coordSysList.selection = prevCoordsys
			8: coordSysList.selection = prevCoordsys
			7: (
				obj = pickObject message:"Pick object to use as reference for coordinate system" count:1 select:false
				if obj != undefined then (
					local list = coordSysList.items
					append list obj.name
					coordSysList.items = list
					coordSysList.selection = coordSysList.items.count
				) else (
					coordSysList.selection = prevCoordsys
				)
			)
		)
		prevCoordsys = coordSysList.selection
	)

-- Event Handlers
-------------------
	on cntr changed state do (changeCenter cntr.state)

	on cntrObj picked object do cpos = centerObj()
	
	on scaleX changed state do scaleAxes.x = (boolToInt scaleX.state)
	on scaleY changed state do scaleAxes.y = (boolToInt scaleY.state)
	on scaleZ changed state do scaleAxes.z = (boolToInt scaleZ.state)
	
	on coordSysList selected item do (changeCoordsys item)
	
	on scalePer buttondown do (savePrevPos())
	on scalePer buttonup do (scalePer.value=100; undoEnabled = true; btUndo.enabled = undoEnabled)
	on scalePer changed value do (changeCenter cntr.state; rePos scalePer.value cpos scaleAxes)

	on btUndo pressed do (undoScalePos(); btUndo.enabled = undoEnabled)

) -- End of Utility

