-- scalePos v1.1
-- changed : 5/9/2001
-- fixed few minor bugs, add ability to use scaled object's center or pivot point.
---------------------------------------------------------------------------------------------------
-- This utility scales the position of the selected objects using an object or the selection center
-- as the center of the scale.
-- Written by Ofer Zelichover. 2001.
-- You may freely distribute or change this script as you see fit.
---------------------------------------------------------------------------------------------------


utility scalePos "Scale Position" (
	local prevPos = #()
	local scaleAxes = [1.0,1.0,1.0]
	local cpos = selection.center
	local rePos, savePrevPos, changeCenter, centerObj, boolToInt

-- GUI
-------
	group "Scale Center: " (
		radiobuttons cntr labels:#("Center of Selection","Object:")
		pickbutton cntrObj "Pick Center of Scale:" enabled:false tooltip:"Pick the object that will be the center point for scaling." message:"Pick the object that will be the center point for scaling."

	)
	
	group "Use scaled object's:" (
		radiobuttons relative labels:#("Pivot Point","Center")
	)
	
	group "Scale Axes: "(
		checkbox scaleX "Scale X" checked:true
		checkbox scaleY "Scale Y" checked:true
		checkbox scaleZ "Scale Z" checked:true
	)
	
	group "Distance Percentage: " (
		spinner scalePer range:[0.01,100000,100] type:#float scale:0.01 align:#center
	)

	group "About: " (
		label txt1 "This utility scales the position"
		label txt2 "of the selected objects using an"
		label txt3 "object or the selection center"
		label txt4 "as the center of the scale."
		label txt5 "Written by Ofer Zelichover."
		label txt6 "2001."
		
	)

-- Event Handlers
-------------------
	on cntr changed state do (changeCenter cntr.state)

	on cntrObj picked object do cpos = centerObj()
	
	on scaleX changed state do scaleAxes.x = (boolToInt scaleX.state)
	on scaleY changed state do scaleAxes.y = (boolToInt scaleY.state)
	on scaleZ changed state do scaleAxes.z = (boolToInt scaleZ.state)
	
	on scalePer buttondown do savePrevPos()
	on scalePer buttonup do scalePer.value=100
	on scalePer changed value do (changeCenter cntr.state; rePos scalePer.value cpos scaleAxes)


-- Functions
--------------
	fn boolToInt bool = (if bool then return 1.0 else return 0.0)

	fn centerObj =(
		if cntrObj.object != undefined then (
			cntrObj.caption = cntrObj.object.name
			return cntrObj.object.pos
		)
		else return selection.center
	)

	fn changeCenter n =(
		case n of (
			1: (cpos = selection.center; cntrObj.enabled=false)
			2: (cpos = centerObj(); cntrObj.enabled=true)
		)
	)

	fn savePrevPos = (
		prevPos = #()
		for o in selection do
			case relative.state of (
				1:	append prevPos o.pos
				2:	append prevPos o.center
			)
	)
	
	fn scalePos origPos Cent Percent axes= (
		local per
		per = ((Percent - 100.0)/100.0)
		return (origPos + ((origPos - Cent) * Per * axes))
	)

	fn rePos scaleDist cpos axes= (
		for i=1 to selection.count do
			case relative.state of (
				1:	selection[i].pos = (scalePos prevPos[i] cpos scaleDist axes)
				2:	selection[i].center = (scalePos prevPos[i] cpos scaleDist axes)
			)
	)

) -- End of Utility

