--******************************************************************************
--*  Lights Grouper Utility v1.0     for Max 4.2                               *
--*  by Ofer Zelichover (c) 8/2001                                             *
--*  www.oferz.f2s.com ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a creadit if you do so ;))               *
--*                                                                            *
--******************************************************************************
--*  I cannot be held responsible for any loss of data, time or any other      *
--*  damage or loss due to the use of this utility.                            *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** vertions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in it please let me know.                            *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--* This utility allows you to define groups of lights, for easy management.   *
--* You can then turn all the lights in the group On/Off and Hide/Unhide       *
--* them. It is useful for task such as having the same scene with day/night   *
--* light schemes.                                                             *
--*                                                                            *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* created : 23/8/2001                                                        *
--* update : 25/8/2001 ver0.3 added save and load to max scene                 *
--* update : 27/8/2001 ver0.4 added save and load to ext file                  *
--* update : 01/9/2001 ver0.5 added control over basic light parameters        *
--* update : 5/9/2001 v0.51 added change handlers fixed minor bugs.            *
--* update : 6/9/2001 v0.52 changed the save with max function. now it saves   *
--*          using string streams, each group has one appData entry. appData   *
--*          starts at 33100 now.                                              *
--*          added rolling text in the about rollout.                          *
--*          created message boxes when there are missing lights when loading. *
--* update : 9/9/2001 v0.53 added: when using select all in groups, if there is*
--*          only one group, now updating GUI. Changed the way the groups GUI  *
--*          updates.                                                          *
--* update : 10/9/2001 v1.0 after some testing, it seems to be stable enough   *
--*          to reach version 1.0. as always, it's probably not bug free, but  *
--*          in a working condition.                                           *
--*                                                                            *
--*                                                                            *
--* Known issues:                                                              *
--*  -if params of lights are changed in the scene it's not reflected in the   *
--*   util.                                                                    *
--*                                                                            *
--*Need to add:                                                                *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*        LightsGrouper_v1.ms        - anywhere or in the max_root\scripts    *
--*                                     folder if you want it to automaticly   *
--*                                     load when you start max.               *
--*                                                                            *
--*   after you run the script you will find it in the customize user interface*
--*   under "Os Tools" category.                                               *
--*                                                                            *
--******************************************************************************


macroScript LightsGrouper

	category:"Os Tools"
	tooltip:"Lights Grouper Utility v1.0"
	buttontext:"LightsGrouper"
(

local lgFloat	-- declare the floater

-- Local Rollouts Declerations
--------------------------------
	local saveLoad

-- Local Function Declerations
--------------------------------
	local loadFromExtFile
	local saveToExtFile
	local loadFromMaxScene
	local saveToMaxScene
	local createChangeHandlers

-- Local Variables Declerations
--------------------------------
	local appDataAddr = 33100	-- the data will be save with globalTrack appData starting at this index
	local errNumMissingLights = 0
	

rollout Main "Light Groups"
(
-- Local Struct Declerations
------------------------------
	struct lightGroup (name, lights, enabled=true, hide=false)

-- Local Variables Declerations
--------------------------------
	local lightGroups = #()
	local lastGrpNum = 0
	
-- Local Function Declerations
-------------------------------
	local bitarrayCount, getSelectedItem
	local isSingleItemSelected
	local lightParamBoxEnabled
	local getLightsNames

-- GUI
----------
	groupbox grpGroupsOutline "" width:188 height:331 pos:[4,5]
	groupbox grpGroups "Groups: " width:186 height:330 pos:[5,5]
		multilistbox mainGroups "" items:#() selection:#() height:10 width:175 pos:[10,20]
		button mainGroupAll "All" pos:[10,160] height:16 width:50
		button mainGroupNone "None" pos:[72,160] height:16 width:50
		button mainGroupInv "Invert" pos:[135,160] height:16 width:50
		button mainAddGroup "Add Group"  align:#left pos:[10,190] toolTip:"Add a new group"
		button mainDelGroup "Remove Selectd" align:#left pos:[90,190] toolTip:"Remove the selected group(s) from the list"
		edittext mainGrpName "Name: " width:175 pos:[10,218] 
		groupbox grpGroupState "Group(s) State: " width:175 height:40 pos:[10,240]
			checkbutton mainGrpEnable "On" pos:[30,255] toolTip:"Turn the lights in the selected group(s) On/Off"
			checkbutton mainGrpHide "Hide" pos:[120,255] toolTip:"Show/Hide the lights in the selected group(s)"
		groupbox grpGroupSelScene "Select in scene: " width:175 height:40 pos:[10,290]
			checkbox mainGrpSelClear "Clear selection" pos:[15,307]
			button mainGrpSelect "Select" pos:[115,305] width:65 toolTip:"If 'Clear selection' is checked, the selection will replace the current selection in the scene, if not it will be added to the current selection" 
		
	groupbox grpLightsOutline "" width:188 height:331 pos:[193,5] enabled:false
	groupbox grpLights "Lights: " width:186 height:330 pos:[194,5] enabled:false
		multilistbox mainGroupLights "" items:#() selection:#() height:10 width:175 pos:[200,20] enabled:false
		button mainLightAll "All" pos:[200,160] height:16 width:50 enabled:false
		button mainLightNone "None" pos:[262,160] height:16 width:50 enabled:false
		button mainLightInv "Invert" pos:[325,160] height:16 width:50 enabled:false
		button mainAddLights "Add Lights"  align:#left pos:[200,190] enabled:false
		button mainDelLights "Remove Selected" align:#left pos:[275,190] enabled:false
		groupbox grpLightParam "Light parameters: " width:175 height:115 pos:[200,215]
			button mainLightSelect "S" width:13 height:38 pos:[203,230] toolTip:"Select light in scene"
			checkbox mainLightOn "On" pos:[222,230]
			edittext mainLightName "Name:" pos:[260,230] width:110
			spinner mainLightMult "Multiplier:" range:[-1000.0,1000.0,1.0] type:#float scale:0.1 width:55 pos:[257,250]
			colorpicker mainLightColor "Color:" fieldWidth:20 height:18 pos:[320,249] color:white
			checkbox mainLightShad "Shadow" pos:[205,275]
			dropdownlist mainLightShadType "" items:#("Shadow Maps","Raytraced") width:100 pos:[270,272]
			label mainLightLabel_1 "MapSize" pos:[205,295]
			spinner mainLightMapSize "" range:[0,100000,512] type:#integer width:50 pos:[205,310]
			label mainLightLabel_2 "Bias" pos:[270,295]
			spinner mainLightBias "" range:[0.0,1000.0,1.0] type:#float width:40 pos:[270,310]
			label mainLightLabel_3 "Samples" pos:[325,295]
			spinner mainLightSamples "" range:[0.0,1000.0,4.0] type:#float width:40 pos:[325,310]
		
-- Functions
-------------
-- this function save automatically the changes to the max scene.
	fn autoSave = (
		if saveLoad.slAutoSave.state then
			saveToMaxScene()
	)
	
--  These two functions filter the lights in the select object window
	fn isLightUsed obj = (
		local tmpList = list = #()
		for g in lightGroups do (
			tmplist = for l in g.lights collect l
			join list tmpList
		)
		return (findItem list obj != 0)
	)
	
	fn pickFilter obj = (isKindOf obj Light and (NOT isLightUsed obj))

-- Inverts the selection in a listbox
	fn selectionInvert sel = (
		try (
			for i = 1 to sel.count do sel[i] = Not sel[i]
		) catch()
		return sel
	)

-- resets the light parameters display
	fn resetLightParam = (
		mainLightName.text = ""
		mainLightMult.value = 1.0
		mainLightColor.color = white
		mainLightMapSize.value = 512
		mainLightBias.value = 1.0
		mainLightSamples.value = 4.0
	)

-- updates light parameters
	fn updateLightParam indx = (
		local a = getSelectedItem mainGroups.selection
		local b = getSelectedItem mainGroupLights.selection
		local lit = lightGroups[a].lights[b]
		case indx of (
			1:	lit.on 						= mainLightOn.state
			2:	lit.name	 				= mainLightName.text
			3:	lit.multiplier	 			= mainLightMult.value
			4:	lit.color 					= mainLightColor.color
			5:	lit.baseobject.castShadows 	= mainLightShad.state
			6:	lit.raytracedShadows 		= (mainLightShadType.selection == 2)
			7:	if NOT lit.raytracedShadows then 
					lit.mapSize				= mainLightMapSize.value
			8:	if lit.raytracedShadows then 
					lit.raytraceBias	 	= mainLightBias.value
				else
					lit.mapBias 			= mainLightBias.value
			9:	if NOT lit.raytracedShadows then 
					lit.sampleRange 		= mainLightSamples.value
			
		)
		lightParamBoxEnabled true
	)

-- updates the data in the light parameters box
	fn updateLightParamGUI lit = (
		mainLightOn.state			= lit.on
		mainLightName.text			= lit.name
		mainLightMult.value 		= lit.multiplier
		mainLightColor.color 		= lit.color
		mainLightShad.state 		= lit.baseobject.castShadows
		mainLightShadType.selection = if lit.raytracedShadows then 2 else 1
		mainLightMapSize.value 		= if NOT lit.raytracedShadows then lit.mapSize else 512
		mainLightBias.value 		= if lit.raytracedShadows then lit.raytraceBias else lit.mapBias
		mainLightSamples.value 		= if NOT lit.raytracedShadows then lit.sampleRange else 4.0
	)


-- enables/disables the elements in the light parameters box
	fn lightParamBoxEnabled enbl = (
		grpLightParam.enabled = enbl
		mainLightSelect.enabled = enbl
		mainLightOn.enabled = enbl
		mainLightName.enabled = enbl
		mainLightMult.enabled = enbl
		mainLightColor.enabled = enbl
		mainLightShad.enabled = enbl
		mainLightShadType.enabled = enbl
		local a = getSelectedItem mainGroups.selection
		local b = getSelectedItem mainGroupLights.selection
		try (typeRaytraced = lightGroups[a].lights[b].raytracedShadows) catch (typeRaytraced = false)
		mainLightLabel_1.enabled = (enbl and (NOT typeRaytraced))
		mainLightMapSize.enabled = (enbl and (NOT typeRaytraced))
		mainLightLabel_2.enabled = enbl
		mainLightBias.enabled = enbl
		mainLightLabel_3.enabled = (enbl and (NOT typeRaytraced))
		mainLightSamples.enabled = (enbl and (NOT typeRaytraced))
	)

-- enables/disables the elements in the lights box
	fn lightsBoxEnabled enbl = (
		grpLights.enabled = enbl
		mainGroupLights.enabled = enbl
		mainLightAll.enabled = enbl
		mainLightNone.enabled = enbl
		mainLightInv.enabled = enbl
		mainAddLights.enabled = enbl
		mainDelLights.enabled = enbl
		
		lightParamBoxEnabled (isSingleItemSelected mainGroupLights.selection)
	)

-- updates the groups GUI
	fn updateGroupsGUI sel= (
		if sel == #{} then (
			mainGrpEnable.state = false
			mainGrpHide.state = false
			mainGrpEnable.text = "On"
			mainGrpHide.text = "Hide"
		) else (
			local onNum = 0
			local hideNum = 0
			local arr = (sel as array)
			for i in arr do (
				if lightGroups[i].enabled then onNum += 1
				if lightGroups[i].hide then hideNum += 1
			)
			mainGrpEnable.state = (onNum > 0)
			mainGrpHide.state = (hideNum > 0)
			mainGrpEnable.text = if (onNum == arr.count) or (onNum == 0) then "On" else "(On)"
			mainGrpHide.text = if (hideNum == arr.count) or (hideNum == 0) then "Hide" else "(Hide)"
		)
		if isSingleItemSelected sel then (
			local n = (sel as array)[1]
			mainGrpName.enabled = true
			mainGrpName.text = lightGroups[n].name
			lightsBoxEnabled true
			mainGroupLights.items = (getLightsNames lightGroups[n].lights)
		) else (
			mainGrpName.enabled = false
			mainGrpName.text = ""
			mainGroupLights.items = #()
			resetLightParam()
			lightsBoxEnabled false
		)
	)

-- adds the lights from the select object window to the lights list, while making
-- sure there are no duplicates
	fn addLightsToList origList addList = (

		local tmpOrig = origList
		local list = #()
		try (
			list = for i in addList where (findItem origList i == 0) collect i
		) catch (return undefined)
		join tmpOrig list
		return tmpOrig
	)

-- returns the first selected item (converts selection bitArray to integer to use as an index)
	fn getSelectedItem arr= (
		try (
				return (arr as array)[1]
		) catch(return undefined)
		return 0
	)
	
-- returns the number of selected objects in the listbox (counts the 'true's in a bitArray)
	fn bitarrayCount bitArr = (
		return (bitArr as array).count
	)
	
-- returns true if only one object is selected in sel (sel is bitArray)
	fn isSingleItemSelected sel = (
		return ((sel as array).count == 1)
	)
	
-- return an array of the names of the lights in the list (for use as items in the lights listbox)
	fn getLightsNames lightsList = (
		local g
		local names = #()
		if lightsList != undefined then
			names = for g in lightsList where (g.name != undefined) collect g.name
		return names
	)

-- return an array of the names of the groups in the list (for use as items in the groups listbox)
	fn getGroupsNames groupList = (
		local g
		local names = #()
		if groupList != undefined then
			for g in groupList where (g.name != undefined) do (
				local onoff = if g.enabled then "On" else "Off"
				local hidden = if g.hide then "Hidden" else "Visible"
				append names (g.name+"   (" +onoff+","+hidden+")")
			)
		return names
	)
	
-- adds a new group to the gourpsList var and update the GUI
	fn addGroup = (
		append lightGroups (lightGroup name:("Group_"+lastGrpNum as string) lights:#())
		lastGrpNum += 1
		mainGroups.items = (getGroupsNames lightGroups)
		local n = mainGroups.items.count
		mainGroups.selection = n
		updateGroupsGUI mainGroups.selection
	)
	
-- Removes the selected groups from the groupsList var and update the GUI
	fn delGroups = (
		local sel = mainGroups.selection
		if sel.count > 0 then (
			for i = sel.count to 1 by -1 where sel[i] do (deleteItem lightGroups i)
		)
		mainGroups.items = (getGroupsNames lightGroups)
		mainGroups.selection = #()
		updateGroupsGUI mainGroups.selection
	)

-- Renames the selected group	
	fn changeGroupName txt= (
		local sel = mainGroups.selection
		local n = getSelectedItem sel
		if n != undefined and bitarrayCount sel == 1 then lightGroups[n].name = txt
		mainGroups.items = (getGroupsNames lightGroups)
	)
	
-- the next two functions change the lights in the selected groups on or off
	fn changeLightsState list state = (
		try (
			for l in list do l.enabled = state
		) catch ()
	)
	
	fn changeGroupEnable state = (
		local sel = mainGroups.selection
		if sel.count > 0 then (
			for i = 1 to sel.count where sel[i] do (
				lightGroups[i].enabled = state
				changeLightsState lightGroups[i].lights lightGroups[i].enabled
			)
		)
		mainGroups.items = (getGroupsNames lightGroups)
		if ((isSingleItemSelected mainGroupLights.selection) and \
				(isSingleItemSelected mainGroupLights.selection)) then (
			local a = getSelectedItem mainGroups.selection
			local b = getSelectedItem mainGroupLights.selection
			local lit = lightGroups[a].lights[b]
			updateLightParamGUI lit
		)
	)
	
-- the next two functions hide or unhide the lights in the selected groups
	fn changeLightsHideState list state = (
		try (
			for l in list do 
				if state then 
					hide l
				else
					unhide l 
		) catch ()
	)

	fn changeGroupHide state = (
		local sel = mainGroups.selection
		if sel.count > 0 then (
			for i = 1 to sel.count where sel[i] do (
				lightGroups[i].hide = state
				changeLightsHideState lightGroups[i].lights lightGroups[i].hide
			)
		)
		mainGroups.items = (getGroupsNames lightGroups)
	)

-- adds lights to the selected group
	fn addLights = (
		local grpName = mainGrpName.text
		local l = undefined
		l = selectByName title:("Select lights to add to "+grpName) buttonText:"Add" \
						filter:pickFilter showHidden:true single:false
		try (
			if l != undefined then (
				local n = getSelectedItem mainGroups.selection
				lightGroups[n].lights = (addLightsToList lightGroups[n].lights l)
				mainGroupLights.items = (getLightsNames lightGroups[n].lights)
			)
		) catch()
	)

-- removes selected lights from the list
	fn delLights = (
		local sel = mainGroupLights.selection
		local n = getSelectedItem mainGroups.selection
		try (
			if sel.count > 0 then (
				for i = sel.count to 1 by -1 where sel[i] do (deleteItem lightGroups[n].lights i)
			)
		) catch ()
		mainGroupLights.items = (getLightsNames lightGroups[n].lights)
		mainGroupLights.selection = #()
	)

-- selects the lights in the selected groups in the scene
	fn selectInScene clearSel = (
		if clearSel then clearSelection()
		local sel = mainGroups.selection
		local list = #()
		if sel.count > 0 then (
			for i = 1 to sel.count where sel[i] do (
				list = for l in lightGroups[i].lights collect l
				selectMore list
			)
		)
	)
	
-- Change handlers functions
	fn delLightFromList obj = (
		for g in lightGroups do (
			for l in g.lights where (l == obj) do
				deleteItem g.lights (findItem g.lights obj)
		)
		if isSingleItemSelected mainGroups.selection then (
			local n = getSelectedItem mainGroups.selection
			mainGroupLights.items = (getLightsNames lightGroups[n].lights)
			mainGroupLights.selection = #()
			resetLightParam()
			lightParamBoxEnabled false
		) 
	)
	
	fn renmaeLight obj = (
		if isSingleItemSelected mainGroups.selection then (
			local n = getSelectedItem mainGroups.selection
			if findItem lightGroups[n].lights obj > 0 then 
				mainGroupLights.items = (getLightsNames lightGroups[n].lights)
		) 
	)

	
-- Event Handlers
-------------------
	on main open do (loadFromMaxScene())

	on mainGroups selectionEnd do (
		mainGroupLights.selection = #()
		updateGroupsGUI mainGroups.selection
	)

	on mainGroupAll pressed do (
		mainGroups.selection = #{1..mainGroups.selection.count}
		updateGroupsGUI mainGroups.selection
	)
	
	on mainGroupNone pressed do (
		mainGroups.selection = #()
		updateGroupsGUI mainGroups.selection
	)
	on mainGroupInv pressed do (
		mainGroups.selection = selectionInvert mainGroups.selection
		updateGroupsGUI mainGroups.selection
	)
	
	on mainAddGroup pressed do (addGroup(); autoSave())
	on mainDelGroup pressed do (delGroups(); autoSave())

	on mainGrpName changed text do (changeGroupName text)
	on mainGrpName entered text do (autoSave())
	on mainGrpEnable changed state do (changeGroupEnable state; autoSave())
	on mainGrpHide changed state do (changeGroupHide state; autoSave())

	on mainGrpSelect pressed do (selectInScene mainGrpSelClear.state)
	
	on mainAddLights pressed do (addLights(); autoSave(); createChangeHandlers())
	on mainDelLights pressed do (delLights(); autoSave(); createChangeHandlers())

	on mainLightAll pressed do (
		mainGroupLights.selection = #{1..mainGroupLights.selection.count}
		resetLightParam()
		lightParamBoxEnabled false
	)
	on mainLightNone pressed do (
		mainGroupLights.selection = #()
		resetLightParam()
		lightParamBoxEnabled false
	)	
	on mainLightInv pressed do (
		mainGroupLights.selection = selectionInvert mainGroupLights.selection
		if (isSingleItemSelected mainGroupLights.selection) then (
			lightParamBoxEnabled true
			local a = getSelectedItem mainGroups.selection
			local b = getSelectedItem mainGroupLights.selection
			local lit = lightGroups[a].lights[b]
			updateLightParamGUI lit
		) else (
			resetLightParam()
			lightParamBoxEnabled false
		)
	)

	on mainGroupLights selectionEnd do (
		if (isSingleItemSelected mainGroupLights.selection) then (
			lightParamBoxEnabled true
			local a = getSelectedItem mainGroups.selection
			local b = getSelectedItem mainGroupLights.selection
			local lit = lightGroups[a].lights[b]
			updateLightParamGUI lit
		) else (
			resetLightParam()
			lightParamBoxEnabled false
		)
	)
	on mainLightSelect pressed do (
		local a = getSelectedItem mainGroups.selection
		local b = getSelectedItem mainGroupLights.selection
		select (lightGroups[a].lights[b])
	)

	on mainLightOn changed state do (updateLightParam 1)
	on mainLightName entered text do (
		updateLightParam 2
		local n = getSelectedItem mainGroups.selection
		mainGroupLights.items = (getLightsNames lightGroups[n].lights)
		autoSave()
	)
	on mainLightMult changed value do (updateLightParam 3)
	on mainLightColor changed color do (updateLightParam 4)
	on mainLightShad changed state do (updateLightParam 5)
	on mainLightShadType selected selection do (updateLightParam 6)
	on mainLightMapSize changed value do (updateLightParam 7)
	on mainLightBias changed value do (updateLightParam 8)
	on mainLightSamples changed value do (updateLightParam 9)
	

) -- End Main rollout


rollout saveLoad "Save/Load 'Light Grouper' data"
(
-- Local Function Declarations
-------------------------------

	
-- GUI
-------------
	radiobuttons slType "" labels:#("Save/Load with max scene","Save to/Load from external file") default:1 columns:1 pos:[10,5]
	checkbutton slAutoSave "Auto save to max scene" checked:true pos:[230,12] toolTip:"Automatically saves every change in Lights Grouper to the max scene"
	button slSave "Save" width:70 pos:[5,50] toolTip:"Save to file or scene"
	button slLoad "Load" width:70 pos:[80,50] toolTip:"Load from file or scene"
	button slDelete "Delete from scene" pos:[160,50] toolTip:"Remove Light Grouper data from max scene"
	button closeFloater "Close" width:70 pos:[300,50] toolTip:"Close Light Grouper"

-- Functions
--------------
-- This function updates the Light Groups rollout GUI
	fn updateGUI = (
		main.mainGroups.items = (main.getGroupsNames main.lightGroups)
		main.mainGroupLights.items = #()
		main.updateGroupsGUI main.mainGroups.selection
	)

-- this function clears the appData 
	fn clearFromMaxScene = (
		local addr = appDataAddr
		try (
			while (getAppData globalTracks addr != undefined) do (
				deleteAppData globalTracks addr
				addr += 1
			)
		) catch (messagebox "Error trying to clear data from max scene." title:"Lights Grouper")
	)

-- this function does the actual writing to the file. it is used by the saveToExtFile function
	fn writeDataToExtFile file grp = (
		try (
			format "<group name:% enable:% hide:%>\n" grp.name grp.enabled grp.hide to:file
			for l in (main.getLightsNames grp.lights) do 
				format "\t<light>%</light>\n" (l as string)	to:file
			format "</group>\n" to:file
		) catch (messagebox "Error write data to ext file")
	)
	
-- strips the <light></light> tags of the string and returns the light name	
	fn getLightName str = (
		local start = findString str "<light>"
		local end = findString str "</light>"
		if  start != undefined and end != undefined then
			return (subString str (start+7) (end-start-7))
		return undefined
	)
	
-- this function does the actual reading from the file. it is used by the loadFromExtFile function
	fn readFromExtFile file = (
		while (NOT eof file) do (
			l = readLine file

			if findString l "<group " == 1 then (
				local namePos = (findString l "name:")
				local enblPos = (findString l "enable:")
				local hidePos = (findString l "hide:")
				local nameStr = subString l (namePos+5) (enblPos-namePos-6)
				local enblStr = subString l (enblPos+7) (hidePos-enblPos-8)
				local hideStr = subString l (hidePos+5) 5
				if nameStr == undefined or nameStr=="" then nameStr = ("Group_"+main.lastGrpNum as string)
				append main.lightGroups (main.lightGroup name:nameStr enabled:(enblStr=="true") hide:(hideStr=="true") lights:#())
				main.lastGrpNum += 1
			) 
		
			if ((findString l "<light>") != undefined) then (
				local o = getNodeByName (getLightName l)
				if o != undefined then (
					append main.lightGroups[main.lightGroups.count].lights o
				) else (
					format "% couldn't be found in the scene, and will be removed from %\n" (getLightName l) nameStr
					errNumMissingLights += 1
				)
			)
		)
	)

	fn done = (
		try (deleteAllChangeHandlers id:#delObj) catch()
		try (deleteAllChangeHandlers id:#renameObj) catch()
		try (closeRolloutFloater lgFloat) catch()
		main.autoSave()
		gc()
		print "Thank you for using Lights Grouper."
	)

-- Event Handlers
-------------------
	on slSave pressed do (if slType.state==1 then saveToMaxScene() else saveToExtFile())
	on slLoad pressed do (if slType.state==1 then loadFromMaxScene() else loadFromExtFile())
	on slDelete pressed do (clearFromMaxScene())
	
	on closeFloater pressed do (
		try (removeRollout Main) catch()
		try (removeRollout saveLoad) catch()
		try (removeRollout aboutRO) catch()
	)

	on saveLoad close do (print "Closing..."; done())
	
) -- End saveLoad rollout


rollout aboutRO "About" rolledUp:true
(

-- Local Variables Declerations
--------------------------------
	local aboutText = #()
	local aboutLineNum = 1
	local aboutClearList = true

-- GUI
-------	
	label aboutLbl_01 "Lights Grouper v1.0 for Max 4.2"
	label aboutLbl_02 "by " pos:[118,25]
	hyperLink aboutMail "Ofer Zelichover" address:"mailto:ofer_z@hotmail.com" color:blue hoverColor:red pos:[135,25]
	label aboutLbl_03 " (c) 8/2001" pos:[210,25]
	hyperLink aboutSite "(www.oferz.f2s.com)" address:"http://www.oferz.f2s.com" color:blue hoverColor:red align:#center
	group "" (
		label aboutRolllbl01
		label aboutRolllbl02
		label aboutRolllbl03
		label aboutRolllbl04
		label aboutRolllbl05
		label aboutRolllbl06
		label aboutRolllbl07
	)
	timer scrollTimer interval:1500 active:true


-- Functions
--------------
	fn creatRollingText = (
		append aboutText "You may use this script freely as you see fit."
		append aboutText "You may use parts or the script or as a whole in your own scripts."
		append aboutText "(it would be nice if you give me a creadit if you do so ;))"
		append aboutText ""
		append aboutText "I cannot be held responsible for any loss of data or work hours,"
		append aboutText "or any other damage or loss due to the use of this utility."
		append aboutText "(Sorry about the way it sounds, but you've got to be careful these days ;))"
		append aboutText ""
		append aboutText "This script was written for max 4.2 and was only tested on max 4.2"
		append aboutText ""
		append aboutText "If you find it useful, or use it in production, I'll be glad to know about it."
		append aboutText "If you find any bugs in it, or have any comments, please let me know."
		append aboutText ""
	)
	
	fn pushText txt = (
		(aboutRolllbl01.text=aboutRolllbl02.text)
		(aboutRolllbl02.text=aboutRolllbl03.text)
		(aboutRolllbl03.text=aboutRolllbl04.text)
		(aboutRolllbl04.text=aboutRolllbl05.text)
		(aboutRolllbl05.text=aboutRolllbl06.text)
		(aboutRolllbl06.text=aboutRolllbl07.text)
		(aboutRolllbl07.text=txt)
	)
	
	fn scrollText =
	(
		if aboutLineNum>aboutText.count then (tmptxt="") else (tmptxt = aboutText[aboutLineNum])
		pushText tmptxt
		if aboutClearList then (
			if (aboutLineNum += 1)>(aboutText.count+7) then aboutLineNum = 1
		) else (
			if (aboutLineNum += 1)>aboutText.count then aboutLineNum = 1
		)
	)

-- Event Handlers
-------------------	
	on scrollTimer tick do (if aboutRO.open then scrollText())
	on aboutRO open do (creatRollingText())

) -- End about rollout



--General Functions
---------------------

-- saves the data to AppData so it will be saved with the max scene
-- the data will be saved from AppData 33100 and on dinamiclly on
-- globalTracks. each group data is stored in a single appData index. 
	fn saveToMaxScene = (
		saveLoad.clearFromMaxScene()
		local addr = appDataAddr
		for g in main.lightGroups do (
			try (
				local list = stringStream ""
				print ("group:") to:list
				print (g.name) to:list
				print (g.enabled as string) to:list
				print (g.hide as string) to:list
				print "Lights:" to:list
				for l in g.lights do (print l.name to:list)
				setAppData globalTracks addr (list)
				addr += 1
			) catch (messagebox "Error write data to max scene")
		)
	)
	
-- loads lights grouper data from the max scene appData.
-- the data is stored with $LightGrouperDataDummy object from index 100 and on.
	fn loadFromMaxScene = (
		errNumMissingLights = 0
		local addr = appDataAddr
		try (
			main.lightGroups = #()
			main.lastGrpNum = 0
			while (getAppData globalTracks addr != undefined) do (
				local ss = stringStream (getAppData globalTracks addr)
				if not eof ss then
					local str = readValue ss
				if (findString str "group:" == 1) then (
					try (
						local nameStr = readValue ss  
						local enblStr = (readValue ss) == "true"
						local hideStr = (readValue ss) == "true"
					) catch (nameStr = ("Group_"+(main.lastGrpNum+1) as string))
					append main.lightGroups (main.lightGroup name:nameStr enabled:enblStr hide:hideStr lights:#())
					main.lastGrpNum += 1
				)
				if not eof ss then
					str = readValue ss
				if (findString str "lights:" == 1) then (
					while NOT eof ss do (				
						local lightStr = readValue ss  
						local l = (getNodeByName lightStr)
						if l != undefined then (
							append main.lightGroups[main.lightGroups.count].lights l
						) else (
							format "% couldn't be found in the scene, and will be removed from %\n" lightStr nameStr
							errNumMissingLights += 1
						)
					)
				)
				addr += 1
			)
		) catch (messagebox "Error reading from max scene" title:"Lights Grouper")
		saveLoad.updateGUI()

		if errNumMissingLights > 0 then
			messagebox ("There were " + errNumMissingLights as string + " lights saved in the Lights Grouper data that were missing from the scene.\n Plsease see listener for a detailed list.") title:"Lights Grouper"

		createChangeHandlers()
	)

-- saves Lights Grouper data to a file
	fn saveToExtFile = (
		local fileName = getSaveFileName types:"Lights Grouper Files (*.dat)|*.dat|All Files (*.*)|*.*"
		if fileName != undefined then (
			f = createFile fileName 
			for g in main.lightGroups do (
				saveLoad.writeDataToExtFile f g
			)
			flush f
			close f
			messagebox "Done saving to file"
		)
	)
	
-- loads Lights Grouper data from a file
	fn loadFromExtFile = (
		errNumMissingLights = 0
		local fileName = getOpenFileName types:"Lights Grouper Files (*.dat)|*.dat|All Files (*.*)|*.*"
		if fileName != undefined then (
			f = openFile fileName 
			if f != undefined then (
				main.lightGroups = #()
				main.lastGrpNum = 0
				saveLoad.readFromExtFile f
			)
			flush f
			close f
			saveLoad.updateGUI()
			if saveLoad.slAutoSave.state then
				saveToMaxScene()
			if errNumMissingLights > 0 then
				messagebox ("There were " + errNumMissingLights as string + " lights in the file that were missing from the scene.\n Plsease see listener for a detailed list.") title:"Lights Grouper"
			createChangeHandlers()
		)
	)


-- Create the Change Handlers
------------------------------
	fn createChangeHandlers = (
		try (deleteAllChangeHandlers id:#delObj) catch()
		try (deleteAllChangeHandlers id:#renameObj) catch()
		
		local list = #()
		for g in main.lightGroups do (
			tmplist = for l in g.lights where (l != undefined) collect l
			join list tmplist
		)
		if list != #() then (
			when list deleted id:#delObj obj do (main.delLightFromList obj)
			when names list change id:#renameObj obj do (main.renmaeLight obj)
		)
	)


-- Create the floater window
-----------------------------
try (closeRolloutFloater lgFloat) catch()
lgFloat = newRolloutFloater "Lights Grouper Utility v1.0" 410 520 10 100

-- Add the rollouts
---------------------
addRollout Main lgFloat
addRollout saveLoad lgFloat
addRollout aboutRO lgFloat

) -- End of macroscript
