--******************************************************************************
--*  FPSmove v1.0                for Max 4.2
--*  by Ofer Zelichover (c) 01/2002
--*  www.tdp.nu/ofer   ;   ofer_z@hotmail.com
--*
--*  Based on idea by Tracker (on the scripts board at http://www.tdp.nu)
--*
--******************************************************************************
--*  You may use this script freely as you see fit.
--*  You may use parts or the script as a whole in your own scripts.
--*  (it would be nice if you give me a credit if you do so ;))
--******************************************************************************
--*  This script comes with no waranty!
--*  Although I tried this script and couldn't find any problems with it, I can
--*  in no way be held responsible for any kind of loss or damage, whether
--*  direct or indirect, due to the use of this script.
--*
--*  ********************************************************************
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***
--*  ********************************************************************
--*
--*  **** This script was written for max 4.2 and wasn't tested on other ****
--*  **** versions of max.                                               ****
--*
--*  If you find any bugs in this script, please let me know.
--******************************************************************************
--* Description
--* -------------
--*  FPSmove is a set of macroscript that allow you to simlate an FPS game
--*  movement inseide max.
--*
--*  After you select the camera you wish to use in the FPSmove Floater, you can
--*  use the macroscripts to move that camera (you can assign the macroscripts
--*  to key for easy momvement).
--*
--******************************************************************************
--* History, Status and Known issues
--* ----------------------------------
--* Created: 01/05/2002 - Ver 1.0
--*
--* Known issues:
--*
--* Need to add:
--*
--******************************************************************************
--* Isntallation:
--* --------------
--*  
--*    put:
--*         FPSmove-v1_0.ms     - anywhere
--*
--*  After you run the script, the FPSmove tools will apear in the
--*  "FPSmove" category in the customize ui menu.
--*
--******************************************************************************

--******************************************************************************
--* Start of macroscripts
--* MODIFY AT YOUR OWN RISK!!! 
--******************************************************************************


macroscript FPSmoveFloater
	category: "FPSmove"
	buttonText: "FPSmove Float"
(
	try (destroyDialog FPSmove)catch()
	
	rollout FPSmove "FPS Move"
	(
	-- Globals
	----------------
		global FPSmoveCam

	-- Locals
	----------------
		local arrows = for i = 1 to 2 collect (bitmap 10 10 color:(color 0 0 0 0))
		local freeLookAng = 5
	 	local pickCamFilter
		
	
	-- GUI
	---------------
		groupbox mvGrp "" width:70 height:70 pos:[15,0]
		button mvForward "" width:15 height:15 images:#(arrows[1],arrows[1],1,1,1,1,1) pos:[42,10]
		button mvLeft "<" width:15 height:15 pos:[20,30]
		button mvRight ">" width:15 height:15 pos:[64,30]
		button mvBack "" width:15 height:15 images:#(arrows[2],arrows[2],1,1,1,1,1) pos:[42,50]
		checkbutton mdFreeLook "Free Look Mode" width:90 height:18 pos:[5,80]
		timer freeLookTimer interval:100 active:false
		groupBox selectCamGrp "Select Camera:" width:96 height:40 pos:[3,105]
		pickButton selectCam "Non Selected" width:90 height:18 pos:(selectCamGrp.pos+[3,16]) filter:pickCamFilter
	
	-- Mouse Tool
	------------------
		tool freeLookTool
		(
			fn rotateCam ang= (
				if viewport.getCamera() != FPSmoveCam then return()
				disableSceneRedraw()
				try (
					in coordsys local (
						rotate FPSmoveCam ang.x y_axis
						rotate FPSmoveCam ang.y x_axis
					)
					FPSmoveCam.dir = FPSmoveCam.dir
				)catch()
				enableSceneRedraw()
			)
		
			fn doFreeMove = (
				if NOT mdFreeLook.state then return #stop
				local p = mouse.pos
				local screenSize = [gw.getWinSizeX(),gw.getWinSizeY()]
				local screenCenter = screenSize/2
				if p.x < 0 OR p.x > screenSize.x then return()
				if p.y < 0 OR p.y > screenSize.y then return()
				local ang = ((p-screenCenter)/screenCenter)
				rotateCam (-freeLookAng*ang)
			
			)
	
			on freeMove do doFreeMove()
		)
	
	
	-- Functions
	---------------------
		fn pickCamFilter obj = isKindOf obj camera
		-- create an arrow bitmap for the GUI
		function createArrow dir = (
			local b = bitmap 10 10 color:white
			local yfrom = 1
			local yto = b.height-2
			case dir of (
				#up: (yfrom = 1; yto = b.height-2)
				#down: (yfrom = b.height-2; yto = 1)
			)
			local yby = (yto-yfrom)/abs(yto-yfrom)
			for y = 1 to b.height-2 do (
				local w = ((2*y)-1)
				if w < 0 then exit
				setpixels b [((b.width-w)/2)+1,(yfrom + (yby*y))] (for i=1 to w collect black)
			)
			b
		)
		
		fn isInBBox obj pos r = (
			local mx = obj.max + [r,r,r]
			local mn = obj.min - [r,r,r]
			(pos.x<=mx.x AND pos.y<=mx.y AND pos.z<=mx.z) AND \
			(pos.x>=mn.x AND pos.y>=mn.y AND pos.z>=mn.z)
		)
		
		fn isColliding pos r = (
			local retVal = false
			for g in geometry where (isInBBox g pos r) do (retVal=true; exit)
			retVal
		)
		
		fn doMove dir step = (
			dir = case dir of (
				#forward:	[0,0,1]
				#back:		[0,0,-1]
				#left:		[1,0,0]
				#right:		[-1,0,0]
			)
			local oldpos = FPSmoveCam.pos
			in coordsys local FPSmoveCam.pos-=step*dir
			if (isColliding FPSmoveCam.pos 5) then FPSmoveCam.pos = oldpos
		)
	
		fn freeLook = (
			if viewport.getCamera()==FPSmoveCam then startTool freeLookTool prompt:"Free Look Mode. Right-click to exit."
			else messageBox "You can only use Free Look from the selected camera's viewport"
			freeLookTimer.active = false
			mdFreeLook.state = false
		)
		
		fn enableGUI enble = (
			mvForward.enabled = enble
			mvLeft.enabled = enble
			mvRight.enabled = enble
			mvBack.enabled = enble
			mdFreeLook.enabled = enble
		)
		
		fn init = (
			arrows[1] = createArrow #up
			arrows[2] = createArrow #down
			mvForward.images = #(arrows[1],arrows[1],1,1,1,1,1)
			mvBack.images = #(arrows[2],arrows[2],1,1,1,1,1)
			freeSceneBitmaps()
			if isKindOf FPSmoveCam camera then selectCam.text=FPSmoveCam.name
			else FPSmoveCam = undefined
			enableGUI (isKindOf FPSmoveCam camera)
		)
	
	
	-- Event Handlers
	-------------------
		on mvForward pressed do (doMove #forward 5)
		on mvBack pressed do (doMove #back 5)
		on mvLeft pressed do (doMove #left 5)
		on mvRight pressed do (doMove #right 5)
	
		on mdFreeLook changed state do (
			if state then (
				freeLookTimer.active = true
				freeLook()
			) else (
				stopTool freeLookTool
				freeLookTimer.active = false
			)
		)

		on selectCam picked obj do (
			if obj != undefined AND isKindOf obj camera then (
				FPSmoveCam=obj
				selectCam.text = obj.name
			)
			enableGUI (isKindOf FPSmoveCam camera)
		)
		
		on freeLookTimer tick do freeLookTool.doFreeMove()
	
		on FPSmove open do init()
	
	) -- end FPSmove rollout
	
	createDialog FPSmove 100 143 style:#(#style_sysMenu, #style_toolWindow)
) -- end FPSmoveFloater macroscript


--******************************************************************************
--*  FPSmoveForward Macroscript
--******************************************************************************

macroscript FPSmoveForward
	category: "FPSmove"
	buttonText: "FPSmove Forward"
(
	fn isInBBox obj pos r = (
		local mx = obj.max + [r,r,r]
		local mn = obj.min - [r,r,r]
		(pos.x<=mx.x AND pos.y<=mx.y AND pos.z<=mx.z) AND \
		(pos.x>=mn.x AND pos.y>=mn.y AND pos.z>=mn.z)
	)
	
	fn isColliding pos r = (
		local retVal = false
		for g in geometry where (isInBBox g pos r) do (retVal=true; exit)
		retVal
	)

	fn doMove step = (
		local oldpos = FPSmoveCam.pos
		in coordsys local FPSmoveCam.pos-=step*[0,0,1]
		if (isColliding FPSmoveCam.pos 5) then FPSmoveCam.pos = oldpos
	)

	fn isEnabledOK = (
		isKindOf FPSmoveCam camera
	)

	on isEnabled return isEnabledOK()
	on execute do (doMove 5)
) -- end of FPSmoveForward macroscript


--******************************************************************************
--*  FPSmoveBack Macroscript
--******************************************************************************

macroscript FPSmoveBack
	category: "FPSmove"
	buttonText: "FPSmove Back"
(
	fn isInBBox obj pos r = (
		local mx = obj.max + [r,r,r]
		local mn = obj.min - [r,r,r]
		(pos.x<=mx.x AND pos.y<=mx.y AND pos.z<=mx.z) AND \
		(pos.x>=mn.x AND pos.y>=mn.y AND pos.z>=mn.z)
	)
	
	fn isColliding pos r = (
		local retVal = false
		for g in geometry where (isInBBox g pos r) do (retVal=true; exit)
		retVal
	)

	fn doMove step = (
		local oldpos = FPSmoveCam.pos
		in coordsys local FPSmoveCam.pos-=step*[0,0,-1]
		if (isColliding FPSmoveCam.pos 5) then FPSmoveCam.pos = oldpos
	)

	fn isEnabledOK = (
		isKindOf FPSmoveCam camera
	)

	on isEnabled return isEnabledOK()
	on execute do (doMove 5)
) -- end of FPSmoveBack macroscript


--******************************************************************************
--*  FPSmoveLeft Macroscript
--******************************************************************************

macroscript FPSmoveLeft
	category: "FPSmove"
	buttonText: "FPSmove Left"
(
	fn isInBBox obj pos r = (
		local mx = obj.max + [r,r,r]
		local mn = obj.min - [r,r,r]
		(pos.x<=mx.x AND pos.y<=mx.y AND pos.z<=mx.z) AND \
		(pos.x>=mn.x AND pos.y>=mn.y AND pos.z>=mn.z)
	)
	
	fn isColliding pos r = (
		local retVal = false
		for g in geometry where (isInBBox g pos r) do (retVal=true; exit)
		retVal
	)

	fn doMove step = (
		local oldpos = FPSmoveCam.pos
		in coordsys local FPSmoveCam.pos-=step*[1,0,0]
		if (isColliding FPSmoveCam.pos 5) then FPSmoveCam.pos = oldpos
	)

	fn isEnabledOK = (
		isKindOf FPSmoveCam camera
	)

	on isEnabled return isEnabledOK()
	on execute do (doMove 5)
) -- end of FPSmoveLeft macroscript


--******************************************************************************
--*  FPSmoveRight Macroscript
--******************************************************************************

macroscript FPSmoveRight
	category: "FPSmove"
	buttonText: "FPSmove Right"
(
	fn isInBBox obj pos r = (
		local mx = obj.max + [r,r,r]
		local mn = obj.min - [r,r,r]
		(pos.x<=mx.x AND pos.y<=mx.y AND pos.z<=mx.z) AND \
		(pos.x>=mn.x AND pos.y>=mn.y AND pos.z>=mn.z)
	)
	
	fn isColliding pos r = (
		local retVal = false
		for g in geometry where (isInBBox g pos r) do (retVal=true; exit)
		retVal
	)

	fn doMove step = (
		local oldpos = FPSmoveCam.pos
		in coordsys local FPSmoveCam.pos-=step*[-1,0,0]
		if (isColliding FPSmoveCam.pos 5) then FPSmoveCam.pos = oldpos
	)

	fn isEnabledOK = (
		isKindOf FPSmoveCam camera
	)

	on isEnabled return isEnabledOK()
	on execute do (doMove 5)
) -- end of FPSmoveRight macroscript



--******************************************************************************
--*  FPSmoveFreeLook Macroscript
--******************************************************************************

macroscript FPSmoveFreeLook
	category: "FPSmove"
	buttonText: "FPSmove Free Look"
(

	try (destroyDialog FPSmoveFreeLook)catch()
	
	rollout FPSmoveFreeLook "FPS Move"
	(
	-- Locals
	----------------
		local freeLookAng = 3
	
	-- GUI
	---------------
		timer freeLookTimer interval:100 active:false
	
	-- Mouse Tool
	------------------
		tool freeLookTool
		(
			fn rotateCam ang= (
				if viewport.getCamera() != FPSmoveCam then return()
				disableSceneRedraw()
				try (
					in coordsys local (
						rotate FPSmoveCam ang.x y_axis
						rotate FPSmoveCam ang.y x_axis
					)
					FPSmoveCam.dir = FPSmoveCam.dir
				)catch()
				enableSceneRedraw()
			)
		
			fn doFreeMove = (
				local p = mouse.pos
				local screenSize = [gw.getWinSizeX(),gw.getWinSizeY()]
				local screenCenter = screenSize/2
				if p.x < 0 OR p.x > screenSize.x then return()
				if p.y < 0 OR p.y > screenSize.y then return()
				local ang = ((p-screenCenter)/screenCenter)
				rotateCam (-freeLookAng*ang)
			)
	
			on freeMove do doFreeMove()
		)
	
	
	-- Functions
	---------------------
		fn init = (
			if isKindOf FPSmoveCam camera AND viewport.getCamera()==FPSmoveCam then (
				freeLookTimer.active = true
				startTool freeLookTool prompt:"Free Look Mode. Right-click to exit."
			) else ( 
				messageBox "You can only use Free Look from the selected camera's viewport"
			)

			freeLookTimer.active = false
			try (destroyDialog FPSmoveFreeLook)catch()
		)
	
		fn done = (
			stopTool freeLookTool
		)
	
	-- Event Handlers
	-------------------
		on freeLookTimer tick do freeLookTool.doFreeMove()
	
		on FPSmoveFreeLook open do init()
		on FPSmoveFreeLook close do done()
	
	) -- end FPSmove rollout
	
-- Macroscript Handlers
--------------------------
	fn isEnabledOK = (
		isKindOf FPSmoveCam camera AND viewport.getCamera()==FPSmoveCam
	)

	on isEnabled return isEnabledOK()
	on execute do (createDialog FPSmoveFreeLook 50 50)
) -- end of FPSmoveFreeLook macroscript
