--******************************************************************************
--*                                                                            *
--*  Bounding boxes 1.0               for Max 4.2                              *
--*  by Ofer Zelichover (c) 10/2001                                            *
--*  www.oferz.f2s.com ;   ofer_z@hotmail.com                                  *
--*                                                                            *
--*  Concept By Metin Seven  (http://www.sevenheaven.nl)                       *
--*                                                                            *
--******************************************************************************
--*  You may use this script freely as you see fit.                            *
--*  You may use parts or the script as a whole in your own scripts.           *
--*  (it would be nice if you give me a credit if you do so ;))                *
--******************************************************************************
--*  This script comes with no waranty!                                        *
--*  Although I tried this script and couldn't find any problems with it, I can*
--*  in no way be held responsible for any kind of loss or damage, whether     *
--*  direct or indirect, due to the use of this script.                        *
--*                                                                            *
--*  ********************************************************************      *
--*  *** IF YOU DON'T LIKE THE ABOVE STATEMENT, DON'T USE THIS SCRIPT ***      *
--*  ********************************************************************      *
--*                                                                            *
--*  **** This script was written for max 4.2 and wasn't tested on other ****  *
--*  **** versions of max.                                               ****  *
--*                                                                            *
--*  If you find any bugs in this script, please let me know.                  *
--******************************************************************************
--* Description                                                                *
--* -------------                                                              *
--* Create a bounding box around a sub-object selection.                       *
--* You can then use the bounding box as a bone for a Linked X-Form operation. *
--*                                                                            *
--******************************************************************************
--* History, Status and Known issues                                           *
--* ----------------------------------                                         *
--* Created: 14/10/2001 - Ver 0.1                                              *
--* 14/10/2001 - ver 0.2                                                       *
--*       - Renamed utility, now called bounding boxes                         *
--*       - Added about dialog                                                 *
--* 14/10/2001 - ver 0.21                                                      *
--*       - Some GUI changes                                                   *
--*       -  Added support for poly objects                                    *
--* 14/10/2001 ver 0.3                                                         *
--*       - added support for faces (by selection or Mat ID) and support for   *
--*          element mode.                                                     *
--* 15/10/2001 ver 0.31                                                        *
--*       - GUI elements' position is relative to the group boxes              *
--*       - color of boxes and boxes' wire color set to yellow                 *
--* 15/10/2001 ver 0.32                                                        *
--*       - Added automatic creation of bBoxes from all mat IDs.               *
--* 15/10/2001 ver 0.33                                                        *
--*       - Added automatic creation of bBoxes  hierarchy from mat IDs.        *
--*       - Made some grammer corrections.                                     *
--*       - Added links to the about window.                                   *
--* 16/10/2001 ver 0.4                                                         *
--*       - Added selection sets editor. (still missing functions)             *
--* 16/10/2001 ver 0.41                                                        *
--*       - you can now use the selection sets to create bBoxes (still need    *
--*         more debugging and features).                                      *
--* 17/10/2001 ver 0.42                                                        *
--*       - test for some GUI changes                                          *
--* 18/10/2001 ver 0.43                                                        *
--*       - Some GUI Changes, selection set now work only with ALL selection   *
--*         Sets (i.e. you can't use only one selection set), it generates     *
--*         one bounding box per selection set.                                *
--*       - Generating box by elements now works.                              *
--* 18/10/2001 ver 0.44                                                        *
--*       - added object selection callback to the selection sets editor       *
--*       - sel. sets editor changes object sub-object level.                  *
--*       - sel. sets editor enables/disables GUI according to object selection*
--*       - selecting an item in the sel. sets editor selects the sub-objects  *
--*         in the scene.                                                      *
--* 18/10/2001 ver 0.45                                                        *
--*       - added hierarchy when creating boxes using selection sets           *
--*       - added change handlers for the picked object rename and delete      *
--*       - sel. sets editor, adder move up and move down                      *
--* 19/10/2001 ver 0.5                                                         *
--*       - it is now a macroScript                                            *
--*       - added pivot alignment to average selection normals                 *
--*       - fixed "no append function for undefined" when adding sel. sets for *
--*         the first time.                                                    *
--* 19/10/2001 ver 0.51                                                        *
--*       - fixed some gramatical errors.                                      *
--*  3/11/2001 ver 0.52                                                        *
--*       - added: when opening the sel sets editor, checks if selection exists*
--*         as a set, if so, highlight it in the list                          *
--*  5/11/2001 ver 0.53                                                        *
--*       - changed the about text, and some other minor textual changes.      *
--*  6/11/2001 ver 0.54                                                        *
--*       - after much searching, i think i finally fixed the bug that caused  *
--*         selection sets to be saved empty in some cases.                    *
--*  7/11/2001 ver 1.0                                                         *
--*       - after much testing, it apears the script is readt for release.     *
--*                                                                            *
--* Known issues:                                                              *
--*                                                                            *
--*                                                                            *
--* Need to add:                                                               *
--* -allow to modify pivot point position interactively(?)                     *
--* -a lot of fault checking...                                                *
--* -when loading sel. sets, check if topology has changed.                    *
--* -improve the pivot alignment to selection normals anerage.                 *
--* -optimized functions.                                                      *
--* -in selection sets editor:                                                 *
--*     + support for mesh select and such for selecting verts/faces when      *
--*       selecting a set from the list.                                       *
--*                                                                            *
--******************************************************************************
--* Isntallation:                                                              *
--* --------------                                                             *
--*    put:                                                                    *
--*          BoundingBoxer_24i.bmp - in (max_root)\ui\icons                    *
--*          BoundingBoxer_24a.bmp - in (max_root)\ui\icons                    *
--*          BoundingBoxer_16i.bmp - in (max_root)\ui\icons                    *
--*          BoundingBoxer_16a.bmp - in (max_root)\ui\icons                    *
--*          BoundingBoxer.ms      - anywhere                                  *
--*                                                                            *
--*  After you run boundingBoxer.ms, the script will appear in the             *
--*  "Os tools" category in the customize ui menu.                             *
--*                                                                            *
--******************************************************************************


--***************************************************************
-- Start of macroScript
--***************************************************************

macroScript BoundingBoxer_mcr
	category:"Os Tools"
	tooltip:"Bounding Boxer 1.0 - create bounding boxes around sub-object selections"
	buttontext:"BBoxer 1.0"
	icon:#("BoundingBoxer",1)
(

-- Global Rollout Declerations
-------------------------------
	global boundingBoxer
	global bbEditSelSets


-- Struct Definitions
------------------------
	struct point3Array (
		items = #(),
		fn count = items.count,
		fn add i = (
			case (classOf i) of (
				point3 :	append items i
				array :		for ii in i where (classOf ii==point3) do append items ii
				default :	return undefined
			)
			return OK
		),
		fn delete i = if classOf i==integer and i>0 and i<=items.count then
			(deleteItem items i;OK) else undefined,
		fn x = for i in items where (classOf i==point3) collect i.x,
		fn y = for i in items where (classOf i==point3) collect i.y,
		fn z = for i in items where (classOf i==point3) collect i.z,
		fn maxPoint = [amax(x()), amax(y()), amax(z())],
		fn minPoint = [amin(x()), amin(y()), amin(z())],
		fn centerPoint = (minPoint()+maxPoint())/2.,
		fn average = (
			local sum = [0,0,0]
			for i in items do sum+=i
			sum/items.count
		)
	)-- end point3Array struct

	struct selSetStruct (
		name,
		items = #()
	)-- end selSetStruct Struct


-- Rollouts
--==============

rollout bbAbout "About Bounding Boxer 1.0"
(

-- Local Variable Declerations
-------------------------------
	-- the text to display, each array item is a line to be scrolled.
	local  txt = #( \
		"Description and Usage:",																\
		"===========================",													\
		"Create a sub-object selection and use Bounding Boxer to create a fitting",\
		"box around the selection. You can then use the created box(es) for a",	\
		"Linked X-Form or as a bone. The various Bounding Boxer options include",\
		"the possibility to automatically create a link hierarchy between created boxes.",\
		"",																		\
		"",																		\
		"-----------------------------------------------------------------------------------------------------------",\
		"You may use this script freely as you see fit.",						\
		"You may use parts or the script as a whole in your own scripts.",		\
		"(it would be nice if you give me a credit if you do so ;))",			\
		"",																		\
		"***************************************************************************************************",	\
		"This script comes with no warranty.",			
		"Although I tried this script and couldn't find any problems with it, I can",\
		"in NO WAY be held responsible for any kind of loss or damage, whether",\
		"direct or indirect, due to the use of this script.",					\
		"",																		\
		"***************************************************************************************************",	\
		"IF YOU DON'T LIKE THE ABOVE STATEMENT,",								\
		"PLEASE DON'T USE THIS SCRIPT.",										\
		"***************************************************************************************************",	\
		"",																		\
		"This script was written for max 4.2 and wasn't tested on",				\
		"other versions of max.",												\
		"",																		\
		"If you find any bugs in this script, please let me know. (ofer_z@hotmail.com)"	\
	)

	-- determines the text alignment (options:#left, #right, #center)
	local textAlign = #center	
	
	-- determines the scroll speed delay (in msecs)
	local scrollSpeed = 90
	
	------------------------------------------------------------------
	-- Init some inner vars
	-- Do NOT change these vars !!!
	local lineNum = 1
	local lineHeight = 17
	local lineOffset = 0
	local controlsList = #()


-- GUI
--------
	label bbAboutLbl_01 "Bounding Boxer ver. 1.0"
	label bbAboutLbl_02 "Co-design and scripting by                           (c) 11/2001 (                               )"
	hyperlink bbLinkOZMail "Ofer Zelichover" color:blue address:"mailto:ofer_z@hotmail.com" offset:[145,-18]
	hyperlink bbLinkOZWeb "www.oferz.f2s.com" color:blue address:"http://www.oferz.f2s.com" offset:[284,-20]
	label bbAboutLbl_03 "Concept, co-design and icon by                       (                                     )"
	hyperlink bbLinkMSMail "Metin Seven" color:blue address:"mailto:metin@sevensheaven.nl" offset:[183,-18]
	hyperlink bbLinkMSWeb "www.sevensheaven.nl" color:blue address:"http://www.sevensheaven.nl" offset:[252,-20]
	groupbox bbAboutGrp "" width:410 height:150 pos:[5,60]
		label scrllbl01 align:textAlign offset:[0,-130]
		label scrllbl02 align:textAlign
		label scrllbl03 align:textAlign
		label scrllbl04 align:textAlign
		label scrllbl05 align:textAlign
		label scrllbl06 align:textAlign
		label scrllbl07 align:textAlign
	
	button bbAboutClose "Close" width:80 pos:[170,220]
	timer scrollTimer interval:scrollSpeed active:true
	

-- Functions
--------------
	fn emptyList n = (
		local tmpList = #()
		for i = 1 to n do
			append tmpList ""
		return tmpList
	)
	
	fn getScrollLabels = (
		local l = #()
		l = for i in bbAbout.controls where ((findString (i as string) "scrllbl")!=undefined) collect i
		return l
	)
	
	fn pushText txt = (
		for i = 1 to (controlsList.count-1) do
			controlsList[i].text = controlsList[i+1].text
		controlsList[controlsList.count].text=txt
	)
	
	fn offsetLines = (
		for c in controlsList do
			c.pos.y -= 1
	)
	
	fn resetLinesOffset = (
		for c in controlsList do
			c.pos.y += lineHeight+1
	)
	
	fn scrollText clearList:true =
	(
		if  lineOffset >= lineHeight then (
			lineOffset = 0
			resetLinesOffset()
			if lineNum>txt.count then (tmptxt="") else (tmptxt=txt[lineNum])
			pushText tmptxt
			if clearList then (
				if (lineNum += 1)>(txt.count+controlsList.count) then lineNum = 1
			) else (
				if (lineNum += 1)>txt.count then lineNum = 1
			)
		) else (
			lineOffset += 1
		)
		offsetLines()
	)


-- Event Handlers
-------------------
	on scrollTimer tick do (scrollText())

	on bbAboutClose pressed do (destroyDialog bbAbout; gc())
	on bbAbout Open do (controlsList = getScrollLabels())
	
) -- end bbAbout rollout


--=================================================================
-- Edit Selection Sets Rollout
--=================================================================

rollout bbEditSelSets "Edit Selection Sets"
(
-- Global Variable Declerations
--------------------------------
	global bitArr = #{}


-- Local Variable Declerations
--------------------------------
	local essSelSets = #()


-- GUI
---------
	groupbox essGrpSelectedObj "Selected Object: " width:150 height:35 pos:[5,5]
		label essLblSelectedObj "None" align:#left pos:(essGrpSelectedObj.pos+[5,15])

	groupbox essGrpSubObj "Sub-Object Level: " width:150 height:35 pos:[5,40]
		radiobuttons essSubObjLevel "" labels:#("Vertex    ","Face") pos:(essGrpSubObj.pos+[10,15])

	groupbox essGrpSets "Vertex Selection Sets: " width:150 height:145 pos:[5,75]
		listbox essSelSetsList "" items:#() width:140 height:5 pos:(essGrpSets.pos+[5,15])
		button essMoveUp "Move Up" height:14 width:68 pos:(essGrpSets.pos+[5,88])
		button essMoveDown "Move Down" height:14 width:68 pos:(essGrpSets.pos+[77,88])
		edittext essSelSetName "" fieldWidth:138 height:15 pos:(essGrpSets.pos+[2,106])
		button essAddSet "Add" width:44 height:14 pos:(essGrpSets.pos+[5,125])
		button essRenameSet "Rename" width:45 height:14 pos:(essGrpSets.pos+[52,125])
		button essRemoveSet "Remove" width:45 height:14 pos:(essGrpSets.pos+[100,125])

	button essClose "Close" width:100 height:16 pos:[30,225]


-- Functions
---------------
	-- These functions store and retrieve the object's sets information.
	-- the info is stored at appData addresses: 
	-- for editable_mesh 49440-vertex list, 49441-face list.
	-- for editable_poly 49450-vertex list, 49451-face list.
	fn getVertexSetsListFromObj obj = (
		case (classOf obj) of (
			Editable_mesh: addr = 49440
			Editable_poly: addr = 49450
		)
		local ss = try((getAppData obj addr) as stringStream) catch(stringStream "")
		sets = #()
		while NOT eof ss do (
			local str = readLine ss
			local n = findString str "\" #"
			bitArr = #{}
			execute ("bitArr = " + (subString str (n+2) (str.count-(n+1))))
			local tmpSet = selSetStruct (subString str 2 (n-2)) (bitArr as Array)
			append sets tmpSet
		)
		for s in sets do s.items = (s.items) as array
		return sets
	)

	fn getFaceSetsListFromObj obj = (
		case (classOf obj) of (
			Editable_mesh: addr = 49441
			Editable_poly: addr = 49451
		)
		local ss = try((getAppData obj addr) as stringStream) catch(stringStream "")
		sets = #()
		while NOT eof ss do (
			local str = readLine ss
			local n = findString str "\" #"
			bitArr = #{}
			execute ("bitArr = " + subString str (n+2) (str.count-(n+1)))
			local tmpSet = selSetStruct (subString str 2 (n-2)) (bitArr as Array)
			append sets tmpSet
		)
		for s in sets do s.items = (s.items) as array
		return sets
	)

	fn putVertexSetsListToObj obj = (
		case (classOf obj) of (
			Editable_mesh: addr = 49440
			Editable_poly: addr = 49450
		)
		local ss = stringStream ""
		for s in essSelSets where (isKindOf s selSetStruct) do
			format "\"%\" %\n" s.name (s.items as bitArray) to:ss
		setAppData obj addr (ss as string)
	)

	fn putFaceSetsListToObj obj = (
		case (classOf obj) of (
			Editable_mesh: addr = 49441
			Editable_poly: addr = 49451
		)
		local ss = stringStream ""
		for s in essSelSets where (isKindOf s selSetStruct) do
			format "\"%\" %\n" s.name (s.items as bitArray) to:ss
		setAppData obj addr (ss as string)
	)

	-- saves the selection sets list to the object
	fn saveToObj obj subObjType:essSubObjLevel.state = (
		case subObjType of (
			1: putVertexSetsListToObj obj
			2: putFaceSetsListToObj obj
		)
	)
	
	-- loads the selection sets list from the object, sets it to essSelSets and returns it
	fn loadFromObj obj subObjType:essSubObjLevel.state = (
		case subObjType of (
			1: essSelSets = getVertexSetsListFromObj obj
			2: essSelSets = getFaceSetsListFromObj obj
		)
		return essSelSets
	)
	
-- General Functions
	fn bitArrayEqual ba1 ba2 = (((ba1-ba2) as array).count==0) and (((ba2-ba1) as array).count==0)

	-- returns index of _name item in selSetArr (by name only) if not found returns 0
	fn findSelSetItem selSetArr _name = (
		local namesArr = for s in selSetArr where (isKindOf s selSetStruct) collect s.name
		return (findItem namesArr _name)
	)

	-- checks that the object selection is supported
	fn checkObjSelection = (
		selection.count==1 and (classOf selection[1]==Editable_mesh or classOf selection[1]==Editable_poly)
	)

	-- check if the current subobject level is supported
	fn checkSubObjectLevel = (
		if NOT checkObjSelection() then return false
		try (
			case (classOf selection[1]) of (
				Editable_mesh: return #{1,3,4,5}[subObjectLevel]
				Editable_poly: return #{1,4,5}[subObjectLevel]
			)
		) catch (return false)
	)	
	
	-- checks if the current selection is already saved as a sel. set, if so returns the index of it.
	fn findSelInSetsList setsList list = (
		if list.count == 0 then return undefined
		for i=1 to setsList.count do
			if bitArrayEqual (setsList[i].items as bitArray) (list as bitArray) then
				return i
		return 0
	) 
	
	-- returns the current subobject level for use with the essSubObjLevel radiobuttons
	fn getSubObjectLevel = (
		if NOT checkObjSelection() then return 0
		n = subObjectLevel
		if n==1 then return 1
		case (classOf selection[1]) of (
			Editable_mesh: if (#{3,4,5}[subObjectLevel]) then return 2
			Editable_poly: if (#{4,5}[subObjectLevel]) then return 2
		)
		return 0
	)
	
	-- changes subobjectLevel according to lvl (1=vertex; 2=face/poly)
	fn changeSubObjLevel lvl = (
		if checkObjSelection() then obj = selection[1]
			else return undefined
		local tmpLevel
		if lvl==1 then (
			tmpLevel=lvl
		) else (
			case (classOf obj) of (
				Editable_mesh: tmpLevel = 3
				Editable_poly: tmpLevel = 4
			)
		)
		try (
			max modify mode
			subObjectLevel = tmpLevel
		) catch(print "error changing sub-object level.")
	)

	-- selects verts (subObjLvl=1) or face (subObjLvl=2) using list for vertex/face index
	fn selectSubObjElements subObjLvl list = (
		try (
			if checkObjSelection() then obj = selection[1]
			case subObjLvl of (
				1: (
						case (classOf obj) of (
							Editable_mesh: setVertSelection obj list
							Editable_poly: polyop.setVertSelection obj list
						)
					)
				2: setFaceSelection obj list
			)
			update obj
		) catch()
	)


-- GUI Functions
	-- enables/disables parts of the GUI.
	fn enableSetsDisplay enbl = (
		essGrpSubObj.enabled	= enbl
		essSubObjLevel.enabled	= enbl
		essGrpSets.enabled 		= enbl
		essSelSetsList.enabled 	= enbl
		essMoveUp.enabled 		= enbl
		essMoveDown.enabled 	= enbl
		essSelSetName.enabled 	= enbl
		essAddSet.enabled 		= enbl
		essRenameSet.enabled 	= enbl
		essRemoveSet.enabled 	= enbl
	)
	
	fn displaySelectedObjName = (
		if checkObjSelection() then n = selection[1].name else n = "Wrong object type"
		if selection.count == 0 then n = "None"
		if selection.count > 1 then n = "Multiple selection"
		essLblSelectedObj.text = n
	)
	
	-- updates the selection sets list (by loading from the object)
	fn updateSetsList = (
		if checkObjSelection() then (
			loadFromObj selection[1]
			essSelSetsList.items = for s in essSelSets collect s.name
		) else (
			essSelSets = #()
			essSelSetsList.items = #()
		)
	)

	-- this is the function the the selectionSetChanged callback calls
	fn selectedObjChanged = (
		displaySelectedObjName()
		essSelSetsList.items = #()
		if checkObjSelection() then (
			updateSetsList()
			if essSelSetsList.items.count > 0 then essSelSetsList.selection=1
		)
		enableSetsDisplay (checkObjSelection())
	)

	-- add a selection set to the list
	fn addSet = (
		if NOT checkSubObjectLevel() then (
			messagebox "Cannot add selection set in this sub-Object level." title:"Selection Sets Editor"
			return undefined
		)
		if checkObjSelection() then (
			essSubObjLevel.state = getSubObjectLevel()
			updateSetsList()

			case essSubObjLevel.state of (
				1:	namePrefix = "Vertex_"
				2:	namePrefix = "Face_"
			)
			local i = 0
			do (
				setName = namePrefix + ("Set_"+ i as string)
				i += 1
			) while (findSelSetItem essSelSets setName)!=0
			if essSelSetName.text != "" then 
				setName = essSelSetName.text
			local n = findSelSetItem essSelSets setName
			obj = selection[1]
			local tmpSet = undefined
			case essSubObjLevel.state of (
				1:	tmpSet = (selSetStruct setName (getVertSelection obj as array))
				2:	tmpSet = (selSetStruct setName (getFaceSelection obj as array))
			)
			if (i=(findSelInSetsList essSelSets tmpSet.items))!=0 and i!=undefined then (
				messagebox ("This selection is already saved as "+essSelSets[i].name) title:"Selection Sets Editor"
				return undefined
			)
			if i==undefined then return undefined
			if n == 0 then (
				if tmpSet != undefined and tmpSet.items.count > 0 then
					append essSelSets tmpSet
			) else (
				if tmpSet != undefined and tmpSet.items.count > 0 then
					essSelSets[n].items = tmpSet.items
			)
			saveToObj obj
			updateSetsList()
			essSelSetsList.selection = essSelSetsList.items.count
		)
	)
	
	-- rename a selection set
	fn renameSet = (
		if checkObjSelection() then local obj=selection[1]
			else return undefined
		if essSelSetsList.items.count>0 and essSelSetsList.selection>0 then (
			essSelSets[essSelSetsList.selection].name = essSelSetName.text
			saveToObj obj
			updateSetsList()
		)
	)

	-- remive a selection set
	fn removeSet = (
		if checkObjSelection() then local obj=selection[1]
			else return undefined
		if essSelSetsList.items.count>0 and essSelSetsList.selection>0 then (
			deleteItem essSelSets essSelSetsList.selection
			saveToObj obj
			updateSetsList()
		)
	)
	
	fn moveUp = (
		local n = essSelSetsList.selection
		if n <= 1 then return undefined
		local tmpList = for s in essSelSets collect s
		tmpList[n-1] = essSelSets[n]
		tmpList[n] = essSelSets[n-1]
		essSelSets = tmpList
		saveToObj selection[1]
		if n>1 then essSelSetsList.selection -= 1
		updateSetsList()
	)
	
	fn moveDown = (
		local n = essSelSetsList.selection
		if n >= essSelSets.count then return undefined
		local tmpList = for s in essSelSets collect s
		tmpList[n+1] = essSelSets[n]
		tmpList[n] = essSelSets[n+1]
		essSelSets = tmpList
		saveToObj selection[1]
		if n<essSelSets.count then essSelSetsList.selection += 1
		updateSetsList()
	)
	
	-- General events functions
	-- delete the callbacks used by the selection set editor
	fn delCallbacks = (
		try(callbacks.removeScripts id:#bbEditSelSets) catch()
	)
	
	-- generate the callbacks used by the selection set editor
	fn genCallbacks = (
		callbacks.addScript #selectionSetChanged "bbEditSelSets.selectedObjChanged()" id:#bbEditSelSets
	)
	
	-- initialize some stuff on startup
	fn init = (
		delCallbacks()
		try(select boundingBoxer.bbPickObj.object)catch()
		displaySelectedObjName()
		if checkObjSelection() then (
			try(essSubObjLevel.state = boundingBoxer.bbSubObjectLevel.state)catch()
			changeSubObjLevel essSubObjLevel.state
			updateSetsList()
			if essSelSetsList.items.count > 0 then (
				essSelSetsList.selection=1
				selectSubObjElements essSubObjLevel.state essSelSets[essSelSetsList.selection].items
			)
		)
		enableSetsDisplay (checkObjSelection())
		genCallbacks()
		if checkObjSelection() then (
			obj = selection[1]
			local tmpSet = undefined
			case essSubObjLevel.state of (
				1:	tmpSet = (selSetStruct setName (getVertSelection obj as array))
				2:	tmpSet = (selSetStruct setName (getFaceSelection obj as array))
			)
			if (i=(findSelInSetsList essSelSets tmpSet.items))!=0 and i!=undefined then (
				essSelSetsList.selection = i
			)
		)
	)
	
	-- clean the mess left behind when closing
	fn done = (
		delCallbacks()
		if boundingBoxer!=undefined and boundingBoxer.open then
			boundingBoxer.bbSelSetsMoreOps.checked = false
		gc()
	)
	
-- Event Handlers
-------------------
	on essSubObjLevel changed state do (
		essSelSetName.text = ""
		case state of (
			1: (
					essGrpSets.text = "Vertex Selection Sets: "
					changeSubObjLevel state
				)
			2: (
					essGrpSets.text = "Face Selection Sets: "
					changeSubObjLevel state
				)
		)
		updateSetsList()
		essSelSetsList.selection=0
	)

	on essSelSetsList selected item do (
		essSelSetName.text = ""
		selectSubObjElements essSubObjLevel.state essSelSets[item].items
	)

	on essSelSetsList doubleClicked item do (
		essSelSetName.text = essSelSetsList.items[item]
	)

	on essMoveUp pressed do (moveUp())
	on essMoveDown pressed do (moveDown())

	on essAddSet pressed do (addSet())
	on essRenameSet pressed do (renameSet())
	on essRemoveSet pressed do (removeSet())

	on essClose pressed do (destroyDialog bbEditSelSets)
	on bbEditSelSets open do (init())
	on bbEditSelSets close do (done())
	
) -- end bbEditSelSets rollout


--=================================================================
-- Main Rollout
--=================================================================

rollout boundingBoxer "Bounding Boxer 1.0"
(

-- Local Variables Decleration
--------------------------------
	local bbSelectionMode = 1
	local bbPivotPointPos = [0,0,-1]	-- 0=center, -1=min, 1=max
	local bBox = undefined
	local bbSelSets = #()

-- Local Function Declerations
-------------------------------
	local pickObjFilter
	local pivotAlignLabels = #("Min","Center ","Max")
	

-- GUI
--------
	groupbox bbGrpPickObj "Object Selection: " width:190 height:42 pos:[5,5]
		pickbutton bbPickObj "Pick Object" filter:pickObjFilter width:180 pos:(bbGrpPickObj.pos+[5,15])
	
	groupbox bbGrpSubObjectLevel "Sub-Object level: " width:190 height:42 pos:[5,50]
		radiobuttons bbSubObjectLevel labels:#("Vertex ","Face","Element") pos:(bbGrpSubObjectLevel.pos+[5,20])
	
	groupbox bbGrpSelectionType "Vertex selection type: " width:190 height:175 pos:[5,95]
		checkbutton bbSelMode_1 "" width:12 height:12 checked:true highlightcolor:(red/2) pos:(bbGrpSelectionType.pos+[5,16])
		label bbSelModeLbl_1 "Selected" pos:(bbGrpSelectionType.pos+[22,15])
		checkbutton bbSelMode_2 "" width:12 height:12 checked:false highlightcolor:(red/2) enabled:false pos:(bbGrpSelectionType.pos+[5,36])
		label bbSelModeLbl_2 "Material ID:" enabled:false pos:(bbGrpSelectionType.pos+[22,35])
		checkbutton bbSelMode_3 "" width:12 height:12 checked:false highlightcolor:(red/2) enabled:false pos:(bbGrpSelectionType.pos+[5,56])
		label bbSelModeLbl_3 "Generate boxes from all Mat IDs" enabled:false pos:(bbGrpSelectionType.pos+[22,55])
		checkbutton bbSelMode_4 "" width:12 height:12 checked:false highlightcolor:(red/2) enabled:false pos:(bbGrpSelectionType.pos+[5,96])
		label bbSelModeLbl_4 "Generate boxes from all elements" enabled:false pos:(bbGrpSelectionType.pos+[22,95])
		checkbutton bbSelMode_5 "" width:12 height:12 checked:false highlightcolor:(red/2) pos:(bbGrpSelectionType.pos+[5,116])
		label bbSelModeLbl_5 "Generate boxes from selection sets" pos:(bbGrpSelectionType.pos+[22,115])
		spinner bbSelectionMatID "" fieldWidth:50 type:#integer range:[1,65535,1] enabled:false pos:(bbGrpSelectionType.pos+[105,35])
		checkbox bbAutoMatIDHierarchy "Use Mat ID for boxes hierarchy" checked:true enabled:false pos:(bbGrpSelectionType.pos+[17,73])
		checkbutton bbSelSetsMoreOps "Edit Selection Sets ..." width:168 height:14 enabled:true pos:(bbGrpSelectionType.pos+[16,153])
		checkbox bbAutoSelSetsHierarchy "Use sets for boxes hierarchy" checked:true enabled:false pos:(bbGrpSelectionType.pos+[17,133])

	groupbox bbGrpBoxAlign "Bounding Box Alignment: " width:190 height:42 pos:[5,275]
		radiobuttons bbBoxAlign "" labels:#("Selection","Parent Object") columns:4 default:2 pos:(bbGrpBoxAlign.pos+[5,18])
	
	groupbox bbGrpPivot "Bounding box pivot position: " width:190 height:75 pos:[5,320]
		label bbPivotAlignLblX "X:" pos:(bbGrpPivot.pos+[5,15])
		radiobuttons bbPivotAlignX "" labels:pivotAlignLabels columns:4 default:2 pos:(bbGrpPivot.pos+[25,14])
		label bbPivotAlignLblY "Y:" pos:(bbGrpPivot.pos+[5,35])
		radiobuttons bbPivotAlignY "" labels:pivotAlignLabels columns:4 default:2 pos:(bbGrpPivot.pos+[25,34])
		label bbPivotAlignLblZ "Z:" pos:(bbGrpPivot.pos+[5,55])
		radiobuttons bbPivotAlignZ "" labels:pivotAlignLabels columns:4 default:1 pos:(bbGrpPivot.pos+[25,54])
	
	button bbCreate "Create Bounding Box" enabled:false width:190 height:25 pos:[5,(boundingBoxer.height-50)]
	button bbAboutBn "About" width:90 pos:[5,(boundingBoxer.height-20)]
	button bbClose "Close" width:90 pos:[105,(boundingBoxer.height-20)]

	
-- Functions
--------------
	fn pickObjFilter obj = classOf obj==Editable_mesh or classOf obj==Editable_poly

	fn bitArrayEqual ba1 ba2 = (((ba1-ba2) as array).count==0) and (((ba2-ba1) as array).count==0)

	fn rotatePivotOnly obj rot = (
		local invRotVal = inverse (rot as quat)
		in coordsys local obj.rotation*=invRotVal
		obj.objectOffsetRot*=invRotVal
		obj.objectOffsetPos*=invRotVal
	)

	fn rotatePivotDirOnly obj dir = (
		local invRotVal = inverse ((matrixFromNormal dir) as quat)
		invRotVal-=obj.rotation
		in coordsys local obj.rotation*=invRotVal
		obj.objectOffsetRot*=invRotVal
		obj.objectOffsetPos*=invRotVal
	)

	fn createBoundingBox obj pArr center dir parent:undefined nameprefix:"boundingBox" = (
		disableSceneRedraw()
		local m = box prefix:nameprefix
		local p = #((pArr.minPoint()),(pArr.maxPoint()))
		convertToMesh m 
		bBoxVertsPosArr = #()
		for x = 1 to 2 do
			for y = 1 to 2 do
				for z = 1 to 2 do
					append bBoxVertsPosArr ([p[x].x,p[y].y,p[z].z])
		for i = 1 to 8 do
			meshop.setVert m #(9-i) bBoxVertsPosArr[i]
		update m
		m.pivot = m.center + ((p[2]-p[1])*center/2.)
		m.rotation = obj.rotation
		in coordsys obj m.pos = pArr.centerPoint() + ((p[2]-p[1])*center/2.)
		
		if bbBoxAlign.state == 1 then
			rotatePivotDirOnly m dir

		m.renderable = false
		m.material = standard diffuseColor:(yellow+(red/2)) opacity:60
		m.wireColor = yellow
		if parent!=undefined then m.parent = parent
		enableSceneRedraw()
		return m
	)
	
	fn updateSelSetsList = (
		local n = if bbSubObjectLevel.state==3 then 2 else bbSubObjectLevel.state
		bbSelSets = (bbEditSelSets.loadFromObj bbPickObj.object subObjType:n)
	)
	
	fn getVertsFromFaces obj faceArr = (
		local vArr = #()
		case (classOf obj) of (
			Editable_mesh: vArr = (meshop.getVertsUsingFace obj faceArr)
			Editable_poly: vArr = (polyop.getVertsUsingFace obj faceArr)
		)
		return (vArr as array)
	)
	
	fn getFacesUsingMatID obj id = (
		local faceArr = #()
		case (classOf obj) of (
			Editable_mesh:	faceArr = for i=1 to obj.numFaces where (getFaceMatID obj i==id) collect i
			Editable_poly:	faceArr = for i=1 to obj.numFaces where (polyop.getFaceMatID obj i==id) collect i
		)
		return faceArr
	)
	
	fn getVertsFromMatID obj id = (
		local faceArr = #()
		local vArr = #()
		case (classOf obj) of (
			Editable_mesh:	vArr = (meshop.getVertsUsingFace obj (getFacesUsingMatID obj id))
			Editable_poly:	vArr = (polyop.getVertsUsingFace obj (getFacesUsingMatID obj id))
		)
		return (vArr as array)
	)
	
	fn getMatIDs obj = (
		local IDs = #{}
		for i=1 to obj.numFaces do (
			case (classOf obj) of (
				Editable_mesh:	n = getFaceMatID obj i
				Editable_poly:	n = polyop.getFaceMatID obj i
			)
			append IDs n
		)
		return (IDs as array)
	)
	
	fn getElements obj = (
		local elementsList = #()
		for i = 1 to obj.numFaces do (
			case (classOf obj) of (
				Editable_mesh:	faces = (meshop.getElementsUsingFace obj i) as bitArray
				Editable_poly:	faces = (polyop.getElementsUsingFace obj i) as bitArray
			)
			local addFaces = true
			for e in elementsList where (bitArrayEqual e faces) do addFaces = false
			if addFaces then append elementsList faces
		)
		return elementsList
	)
	
	fn getElementsUsingFace obj i = (
		case (classOf obj) of (
			Editable_mesh:	return ((meshop.getElementsUsingFace obj i) as array)
			Editable_poly:	return ((polyop.getElementsUsingFace obj i) as array)
		)
	)
	
	fn getAverageNormalFromVerts obj vertList = (
		local av = point3Array (for i in vertList collect getNormal obj i) 
		return av.average()
	)

	fn getAverageNormalFromFaces obj faceList = (
		local av
		case (classOf obj) of (
			editable_mesh:	av = point3Array (for i in faceList collect getFaceNormal obj i)
			editable_poly:	av = point3Array (for i in faceList collect polyop.getFaceNormal obj i)
		)
		return av.average()
	)
	------------------------------------------------------------------------------
	fn getVertsList obj = (
		updateSelSetsList()
		local vArr = #()
		case bbSubObjectLevel.state of (
			1:	case bbSelectionMode of (
					1:	vArr = #(getVertSelection obj as array)
					5:	(
							for i in bbSelSets do
								append vArr i.items
						)
				)
			2:	case bbSelectionMode of (
					1:	vArr = #(getVertsFromFaces obj (getFaceSelection obj as array))
					2:	vArr = #(getVertsFromMatID obj bbSelectionMatID.value)
					3:	(
							for i in (getMatIDs obj) do
								append vArr (getVertsFromMatID obj i)
						)
					5:	(
							for i in bbSelSets do
								append vArr (getVertsFromFaces obj i.items)
						)
				)
			3:	case bbSelectionMode of (
					1:	vArr = #(getVertsFromFaces obj (getElementsUsingFace obj (getFaceSelection obj as array)))
					2:	vArr = #(getVertsFromMatID obj bbSelectionMatID.value)
					3:	(
							for i in (getMatIDs obj) do
								append vArr (getVertsFromMatID obj i)
						)
					4:	(
							for i in (getElements obj) do
								append vArr (getVertsFromFaces obj (i as array))
						)
				)
		)
		if vArr.count==0 then vArr=#(#())
		vArr
	)
	-----------------------------------------------------------------------------
	fn getNormalAverage obj = (
		updateSelSetsList()
		local nArr = #()
		case bbSubObjectLevel.state of (
			1:	if (classOf obj==editable_mesh) then
					case bbSelectionMode of (
						1:	nArr = #(getAverageNormalFromVerts obj (getVertSelection obj as array))
						5:	(
								for i in bbSelSets do
									append nArr (getAverageNormalFromVerts obj i.items)
							)
					)
			2:	case bbSelectionMode of (
					1:	nArr = #(getAverageNormalFromFaces obj (getFaceSelection obj as array))
					2:	nArr = #(getAverageNormalFromFaces obj (getFacesUsingMatID obj bbSelectionMatID.value))
					3:	(
							for i in (getMatIDs obj) do
								append nArr (getAverageNormalFromFaces obj (getFacesUsingMatID obj i))
						)
					5:	(
							for i in bbSelSets do
								append nArr (getAverageNormalFromFaces obj i.items)
						)
				)
			3:	case bbSelectionMode of (
					1:	nArr = #(getAverageNormalFromFaces obj (getElementsUsingFace obj (getFaceSelection obj as array)))
					2:	nArr = #(getAverageNormalFromFaces obj (getFacesUsingMatID obj bbSelectionMatID.value))
					3:	(
							for i in (getMatIDs obj) do
								append nArr (getAverageNormalFromFaces obj (getFacesUsingMatID obj bbSelectionMatID.value))
						)
					4:	(
							for i in (getElements obj) do
								append nArr (getAverageNormalFromFaces obj (i as array))
						)
				)
		)
		nArr
	)


	-- GUI Functions
	----------------
	fn changeSelectionMode i = (
		bbSelectionMode = i
		bbSelMode_1.checked = i==1
		bbSelMode_2.checked = i==2
		bbSelMode_3.checked = i==3
		bbSelMode_4.checked = i==4
		bbSelMode_5.checked = i==5


		bbSelectionMatID.enabled		= bbSelectionMode==2
		bbAutoMatIDHierarchy.enabled	= bbSelectionMode==3
		bbAutoSelSetsHierarchy.enabled	= bbSelectionMode==5
		
		if #{3,4,5}[bbSelectionMode] then bbCreate.text = "Create Bounding Boxes"
			else bbCreate.text = "Create Bounding Box"
	)
	
	fn selModeEnable n enbl = (
		for c in boundingBoxer.controls where (findString (c as string) ("bbSelMode_" + n as string)!=undefined) do
			c.enabled = enbl
		for c in boundingBoxer.controls where (findString (c as string) ("bbSelModeLbl_" + n as string)!=undefined) do
			c.enabled = enbl
	)

	fn changeSubObjLevel i = (
		case i of (
			1:	( -- Vertex mode
					selModeEnable 2 false
					selModeEnable 3 false
					selModeEnable 4 false
					selModeEnable 5 true
					bbSelectionMatID.enabled = false
					if bbSelectionMode == 2 or bbSelectionMode == 3 then (changeSelectionMode 1)
					if bbSelectionMode == 4 then (changeSelectionMode 1)
					bbGrpSelectionType.text =  "Vertex selection type: "
					bbBoxAlign.enabled = (classOf bbPickObj.object!=editable_poly)
				)
			2:	( -- Face mode
					selModeEnable 2 true
					selModeEnable 3 true
					selModeEnable 4 false
					selModeEnable 5 true
					bbSelectionMatID.enabled = bbSelectionMode == 2
					if bbSelectionMode == 4 then (changeSelectionMode 1)
					bbGrpSelectionType.text =  "Face selection type: "
					bbBoxAlign.enabled = true
				)
			3:	( -- Element mode
					selModeEnable 2 true
					selModeEnable 3 true
					selModeEnable 4 true
					selModeEnable 5 false
					bbSelectionMatID.enabled = false
					if bbSelectionMode == 2 or bbSelectionMode == 3 then (changeSelectionMode 1)
					if bbSelectionMode == 5 then (changeSelectionMode 1)
					bbGrpSelectionType.text =  "Element selection type: "
					bbBoxAlign.enabled = true
				)
		)
	)
	
	-- Create the bounding boxes
	fn createBBox = (
		local parentObj = undefined
		local posArr = #()
		local vArrays = getVertsList bbPickObj.object
		local normalDir = getNormalAverage bbPickObj.object
		if normalDir == #() then normalDir = bbPickObj.object.dir
		for i = 1 to vArrays.count do (
			case (classOf bbPickObj.object) of (
				Editable_mesh: posArr = point3Array (for v in vArrays[i] collect (in coordsys bbPickObj.object meshop.getVert bbPickObj.object v))
				Editable_poly: posArr = point3Array (for v in vArrays[i] collect (in coordsys bbPickObj.object polyop.getVert bbPickObj.object v))
				default: (messagebox "Only mesh and poly objects are supported." title:"Bounding Boxer"; return undefined)
			)
			if posArr.count()>0 then
				if (bbSubObjectLevel.state==2 and bbAutoMatIDHierarchy.checked) or \
				 (bbSelectionMode==5 and bbAutoSelSetsHierarchy.checked) then (
					parentObj = createBoundingBox bbPickObj.object posArr bbPivotPointPos (normalDir[i]) parent:parentObj
				) else (
					createBoundingBox bbPickObj.object posArr bbPivotPointPos (normalDir[i])
				)
			else
				messagebox "No matching sub-object elements were found." title:"Bounding Boxer"
		)
	)

	-- General handlers functions
	fn createEventHandlers obj = (
		when name #(obj) changes id:#boundingBoxerHandlers o do (
			bbPickObj.text = o.name
		)
		when #(obj) deleted id:#boundingBoxerHandlers do (
			bbPickObj.text = "Pick Object"
			bbCreate.enabled = false
		)
	)

	fn deleteEventHandlers = (
		deleteAllChangeHandlers id:#boundingBoxerHandlers
	)
	
	fn done = (
		try(deleteEventHandlers())catch()
		try(destroyDialog bbAbout)catch()
		try(destroyDialog bbEditSelSets) catch()
		gc()
	)


-- Event Handlers
------------------
	on bbPickObj picked obj do (
		if obj!=undefined then (
			try(deleteEventHandlers())catch()
			bbPickObj.text = obj.name
			bbCreate.enabled = true
			updateSelSetsList()
			flashNodes #(obj)
			createEventHandlers obj
			if (classOf obj)==editable_poly and bbSubObjectLevel.state==1 then (
				bbBoxAlign.state = 2
				bbBoxAlign.enabled = false
			) else (
				bbBoxAlign.enabled = true
			)
		)
	)
	
	on bbSubObjectLevel changed state do (changeSubObjLevel state)

	on bbSelMode_1 changed state do (changeSelectionMode 1)
	on bbSelMode_2 changed state do (changeSelectionMode 2)
	on bbSelMode_3 changed state do (changeSelectionMode 3)
	on bbSelMode_4 changed state do (changeSelectionMode 4)
	on bbSelMode_5 changed state do (changeSelectionMode 5)

	on bbSelSetsMoreOps changed state do (
		if state then (
			try(destroyDialog bbEditSelSets) catch()
			createDialog bbEditSelSets 160 235 style:#(#style_ToolWindow, #style_SysMenu)
		) else (
			try(destroyDialog bbEditSelSets) catch()
		)
	)

	on bbPivotAlignX changed state do (bbPivotPointPos.x=state-2)
	on bbPivotAlignY changed state do (bbPivotPointPos.y=state-2)
	on bbPivotAlignZ changed state do (bbPivotPointPos.z=state-2)

	on bbCreate pressed do (createBBox())
	on bbAboutBn pressed do (
		try(destroyDialog bbAbout)catch()
		createDialog bbAbout 420 240 style:#(#style_ToolWindow)
	)
	on bbClose pressed do (
		destroyDialog boundingBoxer
	)
	
	on boundingBoxer close do (done())
	
)-- end rollout BoundingBox


	on execute do (
		-- if utility dialog already open, close it first
		try(destroyDialog bbEditSelSets) catch()
		try(destroyDialog bbAbout)catch()
		try(destroyDialog boundingBoxer) catch()
		
		-- create the main dialog
		createDialog boundingBoxer 200 450 20 110 style:#(#style_titlebar, #style_border, #style_minimizebox, #style_sysmenu)
	)

	
)-- End boundingBoxer macroScript

